/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.analytics.testandtarget;

/**
 * The {@code TestandtargetUnsupportedApiOperationException} signals that an operation could not be performed since the
 * configured API backend does not support it
 * 
 * <p>
 * This exception does not signal an error when communicating with the target API, but rather a refusal of the code
 * interfacing with Target to execute an operation which is not exposed by a specific API backend. An example is the
 * {@link TestandtargetService#listFolders(com.day.cq.wcm.webservicesupport.Configuration)} with the REST API.
 * </p>
 *
 */
public class TestandtargetUnsupportedApiOperationException extends TestandtargetException {

    private static final long serialVersionUID = 1L;

    /**
     * Constructs a new exception instance
     * 
     * @param operationName the name of the operation, e.g. 'listFolders'
     * @param apiKind the kind of the API, e.g. 'REST'
     */
    public TestandtargetUnsupportedApiOperationException(String operationName, String apiKind) {
        super("Operation '" + operationName + "' not supported by API kind '" + apiKind + "'");
    }

}
