/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.day.cq.replication;

import javax.jcr.Session;
import java.util.Map;

import org.osgi.annotation.versioning.ProviderType;

/**
 * A BulkContentBuilder assembles the data for composite actions for the replication.
 */
@ProviderType
public interface BulkContentBuilder {

    /**
     * Create the replication content for multiple resources.
     * If this bulk content builder does not create content for the actual composite replication
     * (e.g. for a delete replication), the bulk content builder should return
     * {@link ReplicationContent#VOID}.
     *
     * @param session session to use to access the repository
     * @param action The composite replication action
     * @param contentFactory the factory for creating binary content objects.
     * @param parameters additional parameters needed for implementation specific purposes
     * @return A newly created replication content or {@link ReplicationContent#VOID}.
     *
     * @throws ReplicationException if an error during assembly of the content occurs.
     */
    ReplicationContent create(Session session, CompositeReplicationAction action, ReplicationContentFactory contentFactory,
                              Map<String, Object> parameters)
            throws ReplicationException;

    /**
     * Returns the name of this bulk content builder.
     * @return the name of this bulk content builder.
     * @since 5.3
     */
    String getName();

    /**
     * Returns the title of this bluk content builder.
     * @return the title.
     * @since 5.3
     */
    String getTitle();
}