/*
 * Copyright 1997-2009 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */

package com.day.cq.spellchecker;

import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONStringer;

/**
 * This class represents the spellchecking result of a single word.
 */
public class WordCheckResult {

    private final String language;

    private final boolean isCorrect;

    private final String[] suggestions;

    public WordCheckResult(boolean isCorrect, String[] suggestions, String language) {
        this.isCorrect = isCorrect;
        this.suggestions = suggestions;
        this.language = language;
    }

    public boolean isCorrect() {
        return this.isCorrect;
    }

    public String[] getSuggestions() {
        return this.suggestions;
    }

    public String getLanguage() {
        return this.language;
    }

    protected void addToJsonStringer(JSONStringer json) throws JSONException {
        json.object();
        json.key("isCorrect");
        json.value(this.isCorrect);
        if (this.suggestions != null) {
            json.key("suggestions");
            json.array();
            for (String suggestion : this.suggestions) {
                json.value(suggestion);
            }
            json.endArray();
        }
        json.endObject();
    }

    public String toJsonString() throws SpellCheckException {
        try {
            JSONStringer json = new JSONStringer();
            this.addToJsonStringer(json);
            return json.toString();
        } catch (JSONException je) {
            throw new SpellCheckException("Could not JSON-ify spellcheck result.", je);
        }
    }

}
