package com.day.cq.wcm.undo;

import java.io.IOException;
import java.io.Writer;

/**
 * <p>Provides undo configuration.</p>
 */

public interface UndoConfigService {

    /**
     * <p>Returns a config value.</p>
     *
     * @param name The name of the config
     * @param type The type of the config
     * @return The config value
     */
    <T> T getConfig(String name, Class<T> type);

    /**
     * <p>Writes config data as required by the clientside implementation.</p>
     *
     * @param out The writer
     * @throws IOException if the client config could not be written to the client
     */
    void writeClientConfig(Writer out) throws IOException;

}
