/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.workflow.util;

import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.HistoryItem;
import com.day.cq.workflow.exec.Workflow;
import com.adobe.granite.workflow.job.WorkflowJob;
import com.adobe.granite.workflow.job.TimeoutJob;
import com.adobe.granite.workflow.job.ExternalProcessJob;
import com.day.cq.workflow.model.WorkflowModel;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.JobManager;
import org.osgi.service.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/**
 * The <code>WorkflowUtil</code> class ...
 */
public abstract class WorkflowUtil {
    /**
	 * Logger instance for this class.
	 */
	private static final Logger log = LoggerFactory.getLogger(WorkflowUtil.class);

    /**
     * Returns a collection of jobs for active workflow instances.
     * @param jobManager used to query for sling jobs on workflow topics
     * @param wfSession used to retrieve the workflow models
     * @return a collection of jobs for active workflow instances.
     */
    public static Collection<Job> getWorkflowJobs(JobManager jobManager, WorkflowSession wfSession) {
        Collection<Job> wfJobs = new ArrayList<Job>();

        WorkflowModel models[];
        try {
            models = wfSession.getModels();
        } catch (WorkflowException we) {
            log.error("Cannot retrieve workflow model list", we);
            return Collections.EMPTY_LIST;
        }

        for (WorkflowModel model: models) {
            String topicName = WorkflowJob.JOB_TOPIC + model.getId().replace("jcr:content", "jcr_content");
            wfJobs.addAll(jobManager.findJobs(JobManager.QueryType.ALL, topicName, -1));
        }

        Collection<Job> toJobs = jobManager.findJobs(JobManager.QueryType.ALL, TimeoutJob.TIMEOUT_JOB_TOPIC, -1);
        wfJobs.addAll(toJobs);

        Collection<Job> extJobs = jobManager.findJobs(JobManager.QueryType.ALL, ExternalProcessJob.JOB_TOPIC, -1);
        wfJobs.addAll(extJobs);

        log.debug("WORKFLOW JOBS: " + wfJobs.size());
        return wfJobs;
    }

    /**
     * Checks if the job specified by the provided workflow instance exists in the collection of sling jobs.
     * @param workflow to check for associate sling jobs, if any
     * @param wfJobs list of existing sling jobs in the system
     * @return false if the workflow specifies a job but the job was not found, true otherwise.
     *
     * @deprecated  No longer useful (stale workflows don't occur enymore).  Always return false.  Can't be removed as it is a documented API.
     */
    public static boolean isStaleWorkflow(Workflow workflow, Collection<Job> wfJobs) {
        return false;
    }

    /**
     * This method returns the userId of the  user who completed the previous step.
     *
     * @param session workflow session
     * @param workflow workflow instance
     * @param nodeId node id of workflow node in question
     * @return user id as string or <code>null</code> if no user could be matched
     * @throws WorkflowException
     */
    public static String getAuthorizableFromLastStep(WorkflowSession session,
                                                           Workflow workflow,
                                                           String nodeId) throws WorkflowException {
        List<HistoryItem> historyList = session.getHistory(workflow);
        for (int i = historyList.size(); i > 0; i--) {
            HistoryItem item = historyList.get(i - 1);
            if (item.getWorkItem() != null && item.getWorkItem().getNode().getId().equals(nodeId)) {
                return item.getUserId();
            }
        }
        return null;
    }
}
