/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ************************************************************************/
package com.adobe.cq.dam.index.builder;

import com.adobe.cq.dam.index.builder.api.PropertyDefinition;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexConstants;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

/**
 * Implements IndexDefinition of Oak Ordered Lucene Property Index
 */
@Deprecated
public class OrderedPropertyDefinition extends SimplePropertyDefinition implements PropertyDefinition {

    boolean ordered;
    String propertyType;

    /**
     * @param property     property to index
     * @param nodeName     property definition node name
     * @param propertyType property definition node name
     */
    public OrderedPropertyDefinition(String property, String nodeName, String propertyType) {
        super(property, nodeName);
        this.ordered = true;
        setPropertyType(propertyType);
    }

    /**
     * @param property     property to index
     * @param nodeName     property definition node name
     * @param propertyType property definition node name
     * @param boost        index time field boost factor
     */
    public OrderedPropertyDefinition(String property, String nodeName, String propertyType, float boost) {
        this(property, nodeName, propertyType);
        this.setBoost(boost);
    }

    public void setPropertyType(String propertyType) {
        this.propertyType = propertyType;
    }

    /**
     * {@inheritDoc}
     */
    public void build(Resource resource) throws PersistenceException {
        super.build(resource);
        ResourceResolver resolver = resource.getResourceResolver();
        Node propDefNode = resolver.getResource(resource, nodeName).adaptTo(Node.class);
        try {
            propDefNode.setProperty(LuceneIndexConstants.PROP_ORDERED, ordered);
            propDefNode.setProperty(LuceneIndexConstants.PROP_TYPE, propertyType);
        } catch (RepositoryException e) {
            throw new PersistenceException("got an "
                    + e.toString() + "rethrowing as PersistenceException");
        }
    }
}
