/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2016 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.granite.auth.oauth;

import org.osgi.annotation.versioning.ConsumerType;


/**
 * An interface to validate the access token.
 * Implementers of this interface should use this to validate the access token.
 *
 * @see AccessTokenProvider
 *
 * @since 3.7
 *
 */
@ConsumerType
public interface TokenValidator {

    /**
     * Specifies the property name of this validator type
     */
    public static final String VALIDATOR_TYPE_PROPERTY = "auth.token.validator.type";

    /**
     * Validates the access token
     * @param accessToken
     * @return {@code true} if the token is valid else {@code false}
     */
    public boolean isValid(String accessToken);
}
