package com.adobe.xfa.text;

import com.adobe.xfa.gfx.GFXColour;
import com.adobe.xfa.ut.Storage;

/**
 * @exclude from published api.
 */

class DrawSelection {
/**
 * @exclude from published api.
 */
	static class Clip {
		float moLeft;
		float moRight;
		GFXColour moFG;
		GFXColour moBG;
		boolean mbTransparent;
	}

	private final Storage<Clip> moClips = new Storage<Clip>();

	DrawSelection () {
	}

	void addClip (float oLeft, float oRight, GFXColour oFG, GFXColour oBG, boolean bTransparent) {
		float oSelStart = oLeft;
		float oSelEnd = oRight;

		if (oSelStart == oSelEnd) {
			return;
		}

		if (oSelStart > oSelEnd) {
			float oSwap = oSelStart;
			oSelStart = oSelEnd;
			oSelEnd = oSwap;
		}

		boolean bReplace = false;

		if (moClips.size() > 0) {
			Clip oPrev = getLastClip();
			if ((oPrev.moFG == oFG) && (oPrev.moBG == oBG) && (oPrev.moRight >= oSelStart)) {
				bReplace = true;
			}
		}

		if (bReplace) {
			Clip oPrev = getLastClip();
			if (oSelEnd > oPrev.moRight) {
				oPrev.moRight = oSelEnd;
			}
		} else {
			Clip oClip = new Clip();
			oClip.moLeft = oSelStart;
			oClip.moRight = oSelEnd;
			oClip.moFG = oFG;
			oClip.moBG = oBG;
			oClip.mbTransparent = bTransparent;
			moClips.add (oClip);
		}
	}

	int getClipCount () {
		return moClips.size();
	}

	Clip getClip (int nIndex) {
		return (Clip) moClips.get (nIndex);
	}

	Clip getLastClip () {
		if (moClips.size() == 0) {
			return null;
		}
		return getClip (moClips.size() - 1);
	}
}
