/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.analytics.sitecatalyst.datainsertion;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The <code>DataInsertionRequest</code> holds all the necessary request parameters
 * for a data insertion request.
 */
@ProviderType
public interface DataInsertionRequest {

    /**
     * Sets a request attribute with <code>name</code> and <code>value</code>.
     * The implementation should properly escape the value according to the
     * underlying request format.
     * 
     * @param name Request parameter name (i.e. prop1)
     * @param value Request parameter value
     * @return Reference to self
     */
    DataInsertionRequest set(String name, String value);

}