/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */

package com.day.cq.reporting;

/**
 * This interface must be implemented by engine-specific config objects.
 */
public interface QueryEngineConfig {

    /**
     * Gets the subpath to be used for determining data.
     *
     * @return The subpath to get data from; <code>null</code> if no subpath should be used
     */
    String getSubPath();

    /**
     * Gets the names of possible properties to get data from.
     *
     * @return The names of possible properties to get data from
     */
    String[] getValueProperties();

    /**
     * Gets the subpath to be used for determining additional data.
     *
     * @return The subpath to get additional data from; <code>null</code> if no subpath
     *         should be used
     */
    String getSecondarySubPath();

    /**
     * Gets the names of possible properties to get additional data from.
     *
     * @return The names of possible properties to get data from
     */
    String[] getSecondaryProperties();

}
