/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.search.facets.buckets;

import com.day.cq.search.Predicate;
import com.day.cq.search.facets.Bucket;

/**
 * <code>SimpleBucket</code> is a bucket representing a single value.
 */
public class SimpleBucket implements Bucket {

    /**
     * The value of this bucket.
     */
    private final String value;

    /**
     * The count for this bucket.
     */
    private long count;

    private Predicate predicate;

    /**
     * Creates a new bucket with the given <code>value</code>.
     *
     * @param value the value of this bucket.
     */
    public SimpleBucket(Predicate predicate, String value) {
        this.predicate = predicate;
        this.value = value;
    }

    /**
     * Increments the count of this bucket.
     */
    public void increment() {
        count++;
    }

    //-----------------------------< Bucket >-----------------------------------

    /**
     * {@inheritDoc}
     */
    public long getCount() {
        return count;
    }

    /**
     * {@inheritDoc}
     */
    public String getValue() {
        return value;
    }

    /**
     * {@inheritDoc}
     */
    public Predicate getPredicate() {
        return predicate;
    }
}
