/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.wcm.designimporter.parser.taghandlers;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

import javax.jcr.RepositoryException;

import org.apache.commons.lang3.StringEscapeUtils;
import org.ccil.cowan.tagsoup.AttributesImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;

import com.day.cq.wcm.designimporter.DesignImportException;
import com.day.cq.wcm.designimporter.util.TagUtils;

/**
 * The default tag handler for handling all the tags the handlers for which don't exist.
 *
 * <p>
 * This tag handler simply bypasses the flow, producing the same HTML as it received via SAX events.
 * </p>
 *
 * @see com.day.cq.wcm.designimporter.parser.taghandlers.factory.DefaultTagHandlerFactory
 */
public class DefaultTagHandler extends AbstractTagHandler {

    static private Set<String> srcNormalizationTags = new HashSet<String>(Arrays.asList(new String[] { "embed", "EMBED", "source",
        "SOURCE", "video", "VIDEO" }));

    private Logger logger = LoggerFactory.getLogger(DefaultTagHandler.class);

    private Attributes atts;

    @Override
    public void beginHandling(String uri, String localName, String qName, Attributes atts) {
        this.atts = atts;

        normalizeSrc(uri, localName, qName, atts);
    }

    private void normalizeSrc(String uri, String localName, String qName, Attributes atts) {
        // Normalize the source path
        if (srcNormalizationTags.contains(localName)) {

            int index = atts.getIndex("src");
            if (index != -1) {
                String type = atts.getType(index);
                try {
                    String value = designImporterContext.designNode.getPath() + "/" + atts.getValue(index);

                    this.atts = new AttributesImpl(atts);
                    ((AttributesImpl) this.atts).setAttribute(index, uri, "src", "src", type, value);

                } catch (RepositoryException e) {
                    logger.error("An error occurred while normalizaling the source path of assets for one of the tags in "
                        + srcNormalizationTags.toString(), e);
                }
            }
        }
    }

    @Override
    public void endHandling(String uri, String localName, String qName) {
        String startTag = getStartTag(uri, localName, qName, atts);
        htmlBuffer.insert(0, startTag);
        String endTag = TagUtils.getMatchingEndTag(startTag);
        htmlBuffer.append(endTag);
    }

    protected String getStartTag(String uri, String localName, String qName, Attributes atts) {
        return TagUtils.getStartTag(uri, localName, qName, atts);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws DesignImportException {
        if (delegate != null) {
            delegate.characters(ch, start, length);
        } else {
            String chars = new String(ch).substring(start, start + length)/* .replace('\n', ' ').replace('\t', ' ').trim() */;
            if (chars.length() > 0) {
                htmlBuffer.append(StringEscapeUtils.escapeHtml4(chars));
            }
        }
    }

}
