package com.day.cq.wcm.designimporter.parser.taghandlers.factory;

import com.day.cq.commons.Externalizer;
import com.day.cq.wcm.designimporter.api.TagHandler;
import com.day.cq.wcm.designimporter.api.TagHandlerFactory;
import com.day.cq.wcm.designimporter.parser.taghandlers.DefaultTagHandler;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.osgi.framework.Constants;

/**
 * The TagHandlerFactory that rolls out {@link DefaultTagHandler} instances
 */
@Service
@Component(metatype = true)
@Properties({
        @Property(name = Constants.SERVICE_RANKING, intValue = 4000, propertyPrivate = false),
        @Property(name = TagHandlerFactory.PN_TAGPATTERN, value = DefaultTagHandlerFactory.TAG_PATTERN)
})
public class DefaultTagHandlerFactory implements TagHandlerFactory {

    static public final String TAG_PATTERN = ".*";

    /**
     * @deprecated Usage of externalizer has been removed (keeping this field for backwards compatibility)
     */
    @Reference
    @Deprecated
    Externalizer externalizer;

    public TagHandler create() {
        DefaultTagHandler defaultTagHandler = new DefaultTagHandler();
        return defaultTagHandler;
    }
}
