package com.adobe.cq.mcm.campaign;

import com.day.cq.mcm.campaign.Defs;

public class Constants {

    /**
     * Defines the base resource types for a newsletter page to be sent with Adobe Campaign.
     */
    public static final String[] RT_CAMPAIGN_NEWSLETTER = {
            "mcm/neolane/components/newsletter",
            "mcm/campaign/components/newsletter",
            "mcm/campaign/components/campaign_newsletterpage",
            "core/email/components/page/v1/page"
        };

    /**
     * Name of the property keeping track of the newsletter UUID.
     */
    public static final String PN_CAMPAIGN_UUID = "cq:acUUID";

    /**
     * Name of the property keeping track of linked Adobe Campaign deliveries.
     */
    public static final String PN_CAMPAIGN_LINKS = "cq:acLinks";

    /**
     * Name of the property keeping track of the newsletter approval.
     */
    public static final String PN_CAMPAIGN_APPROVED = "cq:acApproved";

    /**
     * Name of the property keeping track of the delivery that requested a lock.
     */
    public static final String PN_CAMPAIGN_LOCKED_BY = "cq:acLockedBy";

    /**
     * Name of the property keeping track of the delivery that was used to send the newsletter.
     */
    public static final String PN_CAMPAIGN_SENT_BY = "cq:acSentBy";

    /**
     * Name of the property that provides an explicit mail subject
     */
    public static final String PN_MAIL_SUBJECT = "subject";

    /**
     * Name of the property that provides the plain text variant of a mail
     */
    public static final String PN_MAIL_PLAINTEXT = "plaintext";

    /**
     * Array containing the names of all campaign related properties that need to be
     * removed if a page is copied
     */
    public static final String[] PN_REMOVE_ON_COPY = new String[] {
        PN_CAMPAIGN_UUID, PN_CAMPAIGN_LINKS, PN_CAMPAIGN_APPROVED, PN_CAMPAIGN_LOCKED_BY,
        PN_CAMPAIGN_SENT_BY, Defs.PN_DELIVERY, Defs.PN_PUBLISH_STATUS
    };

    /**
     * Permalink endpoint. Newsletter are accessible at ENDPOINT_PATH/${uuid}.
     */
    public static final String PERMALINK_ENDPOINT_PATH = "/libs/mcm/campaign/content/newsletters";

    /**
     * Parameter that specifies the delivery to get meta data for
     */
    public static final String PRM_DELIVERY = "delivery";

    /**
     * Value for acTemplateId used to get metadata for email delivery with AEM content
     */
    public static final String AC_TEMPLATE_ID_AEM = "mailAEMContent";

}
