/**
 * 
 */
package com.adobe.fontengine.font.opentype;

import java.util.Map;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.LayoutTable.ClassConsumer;
import com.adobe.fontengine.font.opentype.LookupTableHarvester.CoverageLookupHarvester;

class ChainingFormat2Harvester  implements CoverageLookupHarvester, ClassConsumer {
	  private Map lookups;
	  private Subset gids;
	  private boolean classCoveredBySet;
	  private final LookupTableHarvester harvester;
	  
	  ChainingFormat2Harvester(LookupTableHarvester harvester, Map lookups)
	  {
		  this.lookups = lookups;
		  this.harvester = harvester;
	  }
	  
	  public boolean glyph(int glyphID, int classID) throws UnsupportedFontException, InvalidFontException {
			if (gids.getExistingSubsetGid(glyphID) != -1) {
				classCoveredBySet = true;
				return false;
			}
			
			return true;
      }
		  
	  private boolean classesApply(int numGlyphs, int classDefOffset, int chainSubruleOffset, int delta) throws InvalidFontException, UnsupportedFontException
	  {
		  for (int i = 0; i < numGlyphs; i++)
		  {
			  int thisClass = harvester.lookupTable.data.getuint16(chainSubruleOffset + delta + 2*i);
			  classCoveredBySet = false;
			  harvester.lookupTable.iterateClass(classDefOffset, harvester.numGlyphs, this, thisClass);		
			  if (!classCoveredBySet) {
				return false; 
			  }	 
		  }  
		  return true;
	  }

	  public boolean lookupApplies(int coverageGlyph, int stOffset, int coverageIndex, Subset gids) throws InvalidFontException, UnsupportedFontException {
		this.gids = gids;
		
		int classDefOffset = harvester.lookupTable.data.getOffset (stOffset, 6);
		int classIndex = harvester.lookupTable.getClassIndex(coverageGlyph, classDefOffset);
		int chainSubClassSetOffset = harvester.lookupTable.data.getOffset (stOffset, 12 + 2*classIndex);
		if (chainSubClassSetOffset == 0)
			return false;
		
		int backtrackClassDefOffset = harvester.lookupTable.data.getOffset (stOffset, 4);
		int lookaheadClassDefOffset = harvester.lookupTable.data.getOffset (stOffset, 8);
		
		boolean applies = false;
		int chainSubclassRuleCount = harvester.lookupTable.data.getuint16(chainSubClassSetOffset);
		for (int i = 0; i < chainSubclassRuleCount; i++) {
		    int chainSubclassRuleOffset = harvester.lookupTable.data.getOffset(chainSubClassSetOffset, 2 + 2*i);
		    int backtrackGlyphCount = harvester.lookupTable.data.getuint16(chainSubclassRuleOffset);
		    int delta = 0;
		    if (!classesApply(backtrackGlyphCount, backtrackClassDefOffset, chainSubclassRuleOffset, 2))
		    	continue;
		    
		    delta += 2 + 2*backtrackGlyphCount;
		    int inputGlyphCount = harvester.lookupTable.data.getuint16(chainSubclassRuleOffset + delta) - 1;
		    if (!classesApply(inputGlyphCount, classDefOffset, chainSubclassRuleOffset, delta+2))
		    	continue;
		    
		    delta += 2 + 2*inputGlyphCount;
		    int lookAheadGlyphCount = harvester.lookupTable.data.getuint16(chainSubclassRuleOffset + delta);
		    if (!classesApply(lookAheadGlyphCount, lookaheadClassDefOffset, chainSubclassRuleOffset, delta+2))
		    	continue;
		    
		    delta += 2 + 2*lookAheadGlyphCount;
		    int lookupCount = harvester.lookupTable.data.getuint16(chainSubclassRuleOffset + delta);
		    for (int j = 0; j < lookupCount; j++) {
		    	int lookupIndex = harvester.lookupTable.data.getuint16(chainSubclassRuleOffset + delta + 2 + 4*j + 2);
				  // Note that this is a little bit loose. If we wanted the tightest set, we'd
				  // only harvest on the glyphs that this lookup applies to. However, I'll work on the
				  // assumption that if this sublookup applies to other glyphs in 'gids', then there will be
				  // a path that gets us there in most fonts, so we'll want it eventually anyway.(That's a
				  // good sounding justification for matching cooltype's behavior anyway...)
		    	harvester.harvest(gids, lookupIndex, lookups);
		    }

		    applies = true;
		}
		return applies;
		
	}
	  
	public boolean keepGoing() {
		return true;
	}
  }