/*******************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ******************************************************************************/

 /**
 * AdobePatentID="4103US01"
 */

package com.adobe.granite.auth.cert;

import java.security.cert.X509Certificate;
import java.util.Map;

import org.apache.sling.api.resource.ResourceResolver;

import aQute.bnd.annotation.ProviderType;

/**
 * Provides a service to store and map certificates to users.
 */
@ProviderType
public interface UserCertificateMapping {

    /**
     * Maps a certificate to a user by adding it to the global trust store using an autogenerated alias based on the given user ID and a timestamp. 
     * 
     * @param resolver
     *            the resource resolver to use for accessing the global trust-store 
     * @param userId 
     *            the ID of the user to map the certificate to
     * @param certificate
     *            the certificate to map
     * @throws UserCertificateMappingException
     *             if the mapping fails for various reasons like the given user doesn't exist or trust-store access denied
     */
    public void mapCertificate(ResourceResolver resolver, String userId, X509Certificate certificate) throws UserCertificateMappingException;

    /**
     * Unmaps a certificate by removing the certificate from the global trust-store.
     * 
     * @param resolver
     *            the resource resolver to use for accessing the global trust-store 
     * @param alias
     *            the alias of the certificate to remove
     * @throws UserCertificateMappingException
     *             if the certificate removal fails for various reasons like the given alias doesn't exist or trust-store access denied
     */
    public void unmapCertificate(ResourceResolver resolver, String alias) throws UserCertificateMappingException;

    /**
     * List the accessible certificates mapped to the given user.
     * 
     * @param userId
     *            the ID of the user who's certificates are listed
     * @return a map of accessible certificates, using the alias as key, corresponding to the given user
     * @throws UserCertificateMappingException
     *             if the listing fails for various reasons like the given user doesn't exist or trust-store access denied
     */
    public Map<String, X509Certificate> listCertificates(ResourceResolver resolver, String userId) throws UserCertificateMappingException;
}
