/*************************************************************************
* ADOBE CONFIDENTIAL
* ___________________
*
* Copyright 2013 Adobe
* All Rights Reserved.
*
* NOTICE: All information contained herein is, and remains
* the property of Adobe and its suppliers, if any. The intellectual
* and technical concepts contained herein are proprietary to Adobe
* and its suppliers and are protected by all applicable intellectual
* property laws, including trade secret and copyright laws.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe.
**************************************************************************/
package com.adobe.granite.ui.components.ds;

import java.util.Collections;
import java.util.Iterator;

import javax.annotation.Nonnull;

import org.apache.sling.api.resource.Resource;

/**
 * A datasource that has no data.
 */
public final class EmptyDataSource implements DataSource {
    private static DataSource instance;

    /**
     * Returns the singleton instance.
     *
     * @return the singleton instance
     */
    @SuppressWarnings("null")
    @Nonnull
    public static DataSource instance() {
        if (instance == null) {
            instance = new EmptyDataSource();
        }

        return instance;
    }

    private EmptyDataSource() {
    }

    @SuppressWarnings("null")
    @Override
    @Nonnull
    public Iterator<Resource> iterator() {
        return Collections.emptyIterator();
    }

    @Override
    public Long getGuessTotal() {
        return 0L;
    }
}
