/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.template.formatting;

import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.ProtoableNode;
import com.adobe.xfa.XFA;
import com.adobe.xfa.template.containers.ExclGroup;

/**
 * Captionclass for caption objects. An element that describes a caption to be
 * associated with a form field or draw element.
 *
 * @exclude from published api -- Mike Tardif, May 2006.
 */

public final class Caption extends ProtoableNode {

	public Caption(Element parent, Node prevSibling) {
		super(parent, prevSibling, null, XFA.CAPTION, XFA.CAPTION, null,
				XFA.CAPTIONTAG, XFA.CAPTION);
	}

	public Element getElement(int eTag, boolean bPeek, int nOccurrence /* =0 */,
			boolean bReturnDefault /* =false */, boolean bValidate /* =false */) {
		if (eTag == XFA.FONTTAG) {
			if (!isPropertySpecified(eTag, true, nOccurrence)) {
				Element poParent = getXFAParent();

				// Checking the parent is fine only when <font> is a legal child of 
				// the parent... Don't try this when the parent is an <exclGroup>
				if (! (poParent instanceof ExclGroup)) {
					if (bPeek)
						return poParent.getElement(eTag,bPeek,nOccurrence,bReturnDefault,bValidate);

					// Not peeking; must clone the parent's font property and attach it to this XFACaptionImpl

					Element poParentsFontProperty = poParent.getElement(eTag,bPeek,nOccurrence,bReturnDefault,bValidate);
					if (poParentsFontProperty != null) {
						Element oClonedFontProperty = poParentsFontProperty.clone(this, true);
						return oClonedFontProperty;
					}
				}
			}

		}

		return super.getElement(eTag, bPeek, nOccurrence,
				bReturnDefault, bValidate);
	}

}
