// =================================================================================================
// ADOBE SYSTEMS INCORPORATED
// Copyright 2011 Adobe Systems Incorporated
// All Rights Reserved
//
// NOTICE:  Adobe permits you to use, modify, and distribute this file in accordance with the terms
// of the Adobe license agreement accompanying it.
// =================================================================================================

package com.adobe.xmp.schema.model.rules;

import com.adobe.xmp.schema.model.SchemaVisitor;
import com.adobe.xmp.schema.model.TypeRule;
import com.adobe.xmp.schema.model.XMPSchemaException;


/**
 * This rule is a comparison of a Real property with a constant argument.
 * 
 * @author Stefan Makswit
 */
public class RealRule implements TypeRule
{
	private static final long serialVersionUID = 1L;
	/** operator used to compare the operand with the actual XMP value */
	private ComparisonOperator operator;
	/** a double, corresponds with XMP type Real */
	private double operand;

	
	/**
	 * Constructs a new RealRule.
	 *
	 * @param operator the comparison operator
	 * @param operand the double value to compare with
	 */
	public RealRule(ComparisonOperator operator, double operand)
	{
		this.operator = operator;
		this.operand = operand;
	}


	/**
	 * @return Returns the operator.
	 */
	public ComparisonOperator getOperator()
	{
		return this.operator;
	}


	/**
	 * @return Returns the operand.
	 */
	public double getOperand()
	{
		return this.operand;
	}
	
	
	/**
	 * @see com.adobe.xmp.schema.model.TypeRule#accept(com.adobe.xmp.schema.model.SchemaVisitor)
	 */
	public void accept(SchemaVisitor schemaVisitor) throws XMPSchemaException
	{
		schemaVisitor.visit(this);
	}
}
