/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.dam.api.jobs;

import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipOutputStream;

import org.apache.sling.api.resource.Resource;

import aQute.bnd.annotation.ProviderType;

@ProviderType
public interface AssetDownloadService {
    /**
     * Test URL params to see if this request should go to S7 (has image format or image presets)
     *
     * @param configResource     Resource
     * @param downloadSet        Set&lt;Resource&gt; Set of JcrNodeResource, which includes assets' info
     * @param downloadAssets     boolean
     * @param downloadRenditions boolean
     * @param downloadSubassets  boolean
     * @param s7ExportSettings   String: it could be an imagePreset or a string of several modifiers; No s7export if this is null
     * @param date               Date: the export could be scheduled or execute immediately if this is null
     * @param out                ZipOutputStream, pass the output stream filter for the archive downloading
     * @param downloadName       String: download job name
     * @param emailRecipients    String: email recipients
     * @return String: downloadUrl if the archive file is stored in jcr
     * @deprecated			 	 since 6.5, Please use {@link #assetDownload(Resource, Set, boolean, boolean, boolean, String, Date, String, String, OutputStream)} that operates with `OutputStream` instead. 
     */
	@Deprecated
    String assetDownload(final Resource configResource, Set<Resource> downloadSet, boolean downloadAssets, boolean downloadRenditions, boolean downloadSubassets, String s7ExportSettings, Date date, ZipOutputStream out, String downloadName, String emailRecipients);
    
	/**
     * Test URL params to see if this request should go to S7 (has image format or image presets)
     *
     * @param configResource     Resource
     * @param downloadSet        Set&lt;Resource&gt; Set of JcrNodeResource, which includes assets' info
     * @param downloadAssets     boolean
     * @param downloadRenditions boolean
     * @param downloadSubassets  boolean
     * @param s7ExportSettings   String: it could be an imagePreset or a string of several modifiers; No s7export if this is null
     * @param date               Date: the export could be scheduled or execute immediately if this is null
     * @param downloadName       String: download job name
     * @param emailRecipients    String: email recipients
     * @return String: downloadUrl if the archive file is stored in jcr
     * @param out                OutputStream, pass the output stream filter for the archive downloading
     * 
     */
    String assetDownload(final Resource configResource, Set<Resource> downloadSet, boolean downloadAssets, boolean downloadRenditions, boolean downloadSubassets, String s7ExportSettings, Date date, String downloadName, String emailRecipients, OutputStream out);

    /**
     * Computes uncompressed size of assets requested for download
     * @param params asset download options
     * @return long: (uncompressed) size of the content requested for download (in bytes)
     */
    long computeAssetDownloadSize(AssetDownloadParams params);

    /**
     * Test URL params to see if this request should go to S7 (has image format or image presets)
     * @param params asset download options
     * @return String: downloadUrl if the archive file is stored in jcr
     */
    String assetDownload(AssetDownloadParams params);

    /**
     * parameter class for asset download service
     *
     * @return asset download options
     */
    @Deprecated
    public AssetDownloadParams assetDownloadParamsReference();

    static class AssetDownloadParams {

        private Resource configResource;

        /**
         * Set of JcrNodeResource, which includes assets' info
         */
        private Set<Resource> downloadSet;

        /**
         * when true assets aee downloaded
         */
        private boolean downloadAssets;

        /**
         * when true renditions of assets are downloaded
         */
        private boolean downloadRenditions;

        /**
         * when true subaasets are downloaded
         */
        private boolean downloadSubassets;

        /**
         * it could be an imagePreset or a string of several modifiers; No s7export if this is null
         */
        private String s7ExportSettings;

        /**
         * the export could be scheduled or execute immediately if this is null
         */
        private Date date;

        /**
         * ZipOutputStream, pass the output stream filter for the archive downloading
         */
        @Deprecated
        private ZipOutputStream zipOutputStream;
        
        /**
         * OutputStream, a generic output stream for all consumer, but mostly Sling Response's output stream.
         */
        private OutputStream outputStream;

        /**
         * download job name
         */
        private String downloadName;

        private String emailRecipients;

        /**
         * if download should have flat file structure
         */
        private boolean flatStructure;

        /**
         * Permissions/privileges the resource resolver should have in order to download the resource(s)
         */
        private List<String> permissions;

        /**
         * Source workflow of download. Empty value means normal asset download.
         */
        private String source;

        @Deprecated
        public AssetDownloadParams(){
        }

        @Deprecated
        public AssetDownloadParams(Resource configResource, Set<Resource> downloadSet, boolean downloadAssets, boolean downloadRenditions, boolean downloadSubassets, String s7ExportSettings, Date date, ZipOutputStream zipOutputStream, String downloadName, String emailRecipients, boolean flatStructure, List<String> permissions) {
            this.configResource = configResource;
            this.downloadSet = downloadSet;
            this.downloadAssets = downloadAssets;
            this.downloadRenditions = downloadRenditions;
            this.downloadSubassets = downloadSubassets;
            this.s7ExportSettings = s7ExportSettings;
            this.date = date;
            this.zipOutputStream = zipOutputStream;
            this.downloadName = downloadName;
            this.emailRecipients = emailRecipients;
            this.flatStructure = flatStructure;
            this.permissions = permissions;
        }
        
        public AssetDownloadParams(Resource configResource, Set<Resource> downloadSet, boolean downloadAssets, boolean downloadRenditions, boolean downloadSubassets, String s7ExportSettings, Date date, String downloadName, String emailRecipients, boolean flatStructure, List<String> permissions, OutputStream outputStream) {
            this.configResource = configResource;
            this.downloadSet = downloadSet;
            this.downloadAssets = downloadAssets;
            this.downloadRenditions = downloadRenditions;
            this.downloadSubassets = downloadSubassets;
            this.s7ExportSettings = s7ExportSettings;
            this.date = date;
            this.outputStream = outputStream;
            this.downloadName = downloadName;
            this.emailRecipients = emailRecipients;
            this.flatStructure = flatStructure;
            this.permissions = permissions;
        }

        @Deprecated
        public AssetDownloadParams(Resource configResource, Set<Resource> downloadSet, boolean downloadAssets, boolean downloadRenditions, boolean downloadSubassets, String s7ExportSettings, Date date, ZipOutputStream zipOutputStream, String downloadName, String emailRecipients, boolean flatStructure, List<String> permissions, String source) {
            this(configResource, downloadSet, downloadAssets, downloadRenditions, downloadSubassets, s7ExportSettings, date, zipOutputStream, downloadName, emailRecipients, flatStructure, permissions);
            this.source = source;
        }
        
        public AssetDownloadParams(Resource configResource, Set<Resource> downloadSet, boolean downloadAssets, boolean downloadRenditions, boolean downloadSubassets, String s7ExportSettings, Date date, OutputStream outputStream, String downloadName, String emailRecipients, boolean flatStructure, List<String> permissions, String source) {
            this(configResource, downloadSet, downloadAssets, downloadRenditions, downloadSubassets, s7ExportSettings, date, downloadName, emailRecipients, flatStructure, permissions, outputStream);
            this.source = source;
        }

        @Deprecated
        public void setConfigResource(Resource configResource){
            throw new UnsupportedOperationException("This support is reverted. Please use the class constructor to set this value.");
        }

        public Resource getConfigResource() {
            return configResource;
        }
        @Deprecated
        public void setDownloadSet(Set<Resource> downloadSet){
            throw new UnsupportedOperationException("This support is reverted. Please use the class constructor to set this value.");
        }

        public Set<Resource> getDownloadSet() {
            return downloadSet;
        }
        @Deprecated
        public void setDownloadAssets(boolean downloadAssets){
            throw new UnsupportedOperationException("This support is reverted. Please use the class constructor to set this value.");
        }

        public boolean isDownloadAssets() {
            return downloadAssets;
        }
        @Deprecated
        public void setDownloadRenditions(boolean downloadRenditions){
            throw new UnsupportedOperationException("This support is reverted. Please use the class constructor to set this value.");
        }

        public boolean isDownloadRenditions() {
            return downloadRenditions;
        }
        @Deprecated
        public void setDownloadSubassets(boolean downloadSubassets){
            throw new UnsupportedOperationException("This support is reverted. Please use the class constructor to set this value.");
        }

        public boolean isDownloadSubassets() {
            return downloadSubassets;
        }
        @Deprecated
        public void setS7ExportSettings(String s7ExportSettings){
            throw new UnsupportedOperationException("This support is reverted. Please use the class constructor to set this value.");
        }

        public String getS7ExportSettings() {
            return s7ExportSettings;
        }
        @Deprecated
        public void setDate(Date date) {
            throw new UnsupportedOperationException("This support is reverted. Please use the class constructor to set this value.");
        }

        public Date getDate() {
            return date;
        }
        @Deprecated
        public void setZipOutputStream(ZipOutputStream zipOutputStream){
            throw new UnsupportedOperationException("This support is reverted. Please use the class constructor to set this value.");
        }

        @Deprecated
        public ZipOutputStream getZipOutputStream() {
            return zipOutputStream;
        }
        
        public OutputStream getOutputStream() {
        	return outputStream;
        }
        
        @Deprecated
        public void setDownloadName(String downloadName){
            throw new UnsupportedOperationException("This support is reverted. Please use the class constructor to set this value.");
        }

        public String getDownloadName() {
            return downloadName;
        }
        @Deprecated
        public void setEmailRecipients(String emailRecipients){
            throw new UnsupportedOperationException("This support is reverted. Please use the class constructor to set this value.");
        }

        public String getEmailRecipients() {
            return emailRecipients;
        }
        @Deprecated
        public void setFlatStructure(boolean flatStructure){
            throw new UnsupportedOperationException("This support is reverted. Please use the class constructor to set this value.");
        }

        public boolean isFlatStructure() {
            return flatStructure;
        }
        @Deprecated
        public void setPermissions(List<String> permissions){
            throw new UnsupportedOperationException("This support is reverted. Please use the class constructor to set this value.");
        }

        public List<String> getPermissions() {
            return permissions;
        }
        @Deprecated
        public void setSource(String source){
            throw new UnsupportedOperationException("This support is reverted. Please use the class constructor to set this value.");
        }

        public String getSource() { return source; }
        @Deprecated
        public void setPath(String path) {
            throw new UnsupportedOperationException("This support is reverted. Please use the class constructor to set this value.");
        }
        @Deprecated
        public String getPath() {
            throw new UnsupportedOperationException("This support is reverted. Please use the class constructor to set this value.");
        }

    }
}
