/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.util;

import com.adobe.cq.wcm.core.components.internal.DataLayerConfig;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.Template;
import com.day.cq.wcm.api.components.ComponentContext;
import java.util.Optional;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.caconfig.ConfigurationBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComponentUtils {
    public static final String NN_SLING_CONFIGS = "sling:configs";
    public static final String ID_SEPARATOR = "-";
    private static final int ID_HASH_LENGTH = 10;

    private ComponentUtils() {
    }

    public static boolean isDataLayerEnabled(@NotNull Resource resource) {
        return Optional.ofNullable(resource.adaptTo(ConfigurationBuilder.class)).map(builder -> builder.as(DataLayerConfig.class)).map(DataLayerConfig::enabled).orElse(false);
    }

    @NotNull
    public static String getId(@NotNull Resource resource, @Nullable Page currentPage, @Nullable ComponentContext componentContext) {
        return ComponentUtils.getId(resource, currentPage, null, componentContext);
    }

    @NotNull
    public static String getId(@NotNull Resource resource, @Nullable Page currentPage, @Nullable String resourceCallerPath, @Nullable ComponentContext componentContext) {
        return ComponentUtils.getPropertyId(resource).orElseGet(() -> ComponentUtils.generateId(resource, currentPage, resourceCallerPath, componentContext));
    }

    private static Optional<String> getPropertyId(@NotNull Resource resource) {
        return Optional.ofNullable(resource.getValueMap().get("id", String.class)).filter(StringUtils::isNotEmpty).map(StringUtils::trim).map(StringUtils::normalizeSpace).map(val -> StringUtils.replace(val, " ", ID_SEPARATOR));
    }

    @NotNull
    private static String generateId(@NotNull Resource resource, @Nullable Page currentPage, @Nullable String resourceCallerPath, @Nullable ComponentContext componentContext) {
        String resourceType = resource.getResourceType();
        String prefix = StringUtils.substringAfterLast(resourceType, "/");
        String path = resource.getPath();
        if (currentPage != null && componentContext != null) {
            boolean inTemplate;
            PageManager pageManager = currentPage.getPageManager();
            Page resourcePage = pageManager.getContainingPage(resource);
            Template template = currentPage.getTemplate();
            boolean inCurrentPage = resourcePage != null && StringUtils.equals(resourcePage.getPath(), currentPage.getPath());
            boolean bl = inTemplate = template != null && path.startsWith(template.getPath());
            if (resourceCallerPath != null) {
                path = resourceCallerPath.concat(resource.getPath());
            } else if (!inCurrentPage && !inTemplate) {
                for (ComponentContext parentContext = componentContext.getParent(); parentContext != null; parentContext = parentContext.getParent()) {
                    Resource parentContextResource = parentContext.getResource();
                    if (parentContextResource == null) continue;
                    Page parentContextPage = pageManager.getContainingPage(parentContextResource);
                    inCurrentPage = parentContextPage != null && StringUtils.equals(parentContextPage.getPath(), currentPage.getPath());
                    boolean bl2 = inTemplate = template != null && parentContextResource.getPath().startsWith(template.getPath());
                    if (!inCurrentPage && !inTemplate) continue;
                    path = parentContextResource.getPath().concat(resource.getPath());
                    break;
                }
            }
        }
        return ComponentUtils.generateId(prefix, path);
    }

    @NotNull
    public static String generateId(@NotNull String prefix, @NotNull String path) {
        return StringUtils.join(prefix, ID_SEPARATOR, StringUtils.substring(DigestUtils.sha256Hex(path), 0, 10));
    }

    @Nullable
    public static Resource getFeaturedImage(@NotNull Page page) {
        return page.getContentResource("cq:featuredimage");
    }
}

