/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.dom;

import com.adobe.xfa.Attribute;
import com.adobe.xfa.dom.ElementImpl;
import com.adobe.xfa.dom.NodeImpl;
import com.adobe.xfa.dom.QNameImpl;
import com.adobe.xfa.ut.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.TypeInfo;

public class AttrImpl
extends NodeImpl
implements Attr {
    static final int CHECK_DEFAULT = 1;
    static final int CHECK_PREFIX = 2;
    private final ElementImpl mOwner;
    private final Attribute mXFAAttr;
    private QNameImpl mQName;
    private final String mValue;
    private static final QNameImpl gTemporaryQName = new QNameImpl("");

    public Attribute getmXFAAttr() {
        return this.mXFAAttr;
    }

    AttrImpl(ElementImpl owner, Attribute xfaAttr) {
        super(owner);
        this.mOwner = owner;
        this.mXFAAttr = xfaAttr;
        this.mValue = this.mXFAAttr.getAttrValue();
    }

    @Override
    public String getLocalName() {
        this.populate();
        return this.mQName.getLocalName();
    }

    @Override
    public String getName() {
        this.populate();
        return this.mQName.getQName();
    }

    @Override
    public String getNamespaceURI() {
        this.populate();
        return this.mQName.getNamespace();
    }

    @Override
    public String getPrefix() {
        this.populate();
        return this.mQName.getPrefix();
    }

    @Override
    public Element getOwnerElement() {
        return this.mOwner;
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    @Override
    public boolean getSpecified() {
        return true;
    }

    @Override
    public String getValue() {
        return this.mValue;
    }

    @Override
    public boolean isEqualNode(Node other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AttrImpl)) {
            return false;
        }
        AttrImpl otherAttr = (AttrImpl)other;
        if (this.mQName.getLocalName() != otherAttr.mQName.getLocalName() || this.mQName.getNamespace() != otherAttr.mQName.getNamespace()) {
            return false;
        }
        return StringUtils.equalsWithNull(this.mValue, otherAttr.mValue);
    }

    @Override
    public boolean isId() {
        return this.mOwner.getXFAElement().getModel().getDocument().isId(this.mOwner.getNamespaceURI(), this.mOwner.getLocalName(), this.mQName.getNamespace() == null ? "" : this.mQName.getNamespace(), this.mQName.getLocalName());
    }

    @Override
    public boolean isSameNode(Node other) {
        if (!(other instanceof AttrImpl)) {
            return false;
        }
        AttrImpl otherAttr = (AttrImpl)other;
        return this.mXFAAttr == otherAttr.mXFAAttr;
    }

    @Override
    public void setValue(String value) throws DOMException {
        throw new DOMException(7, "");
    }

    @Override
    public String getNodeName() {
        return this.getName();
    }

    @Override
    public short getNodeType() {
        return 2;
    }

    @Override
    public String getNodeValue() throws DOMException {
        return this.mValue;
    }

    final boolean isNamespaceAttr(int checkType) {
        String prefix = this.mXFAAttr.getPrefix();
        if ((checkType & 2) != 0 && prefix == "xmlns") {
            return true;
        }
        return (checkType & 1) != 0 && StringUtils.isEmpty(prefix) && this.mXFAAttr.getName() == "xmlns";
    }

    final boolean isPopulated() {
        return this.mQName != null;
    }

    final void populate() {
        if (this.mQName == null) {
            this.doPopulate();
        }
    }

    private void doPopulate() {
        assert (this.mQName == null);
        this.mQName = gTemporaryQName;
        try {
            String localName = this.mXFAAttr.getLocalName();
            String prefix = this.mXFAAttr.getPrefix();
            String namespaceURI = "";
            if (prefix != "xmlns" && localName != "xmlns") {
                namespaceURI = this.mOwner.lookupNamespaceURI(StringUtils.isEmpty(prefix) ? null : prefix);
            }
            this.mQName = new QNameImpl(namespaceURI, prefix, localName);
        }
        catch (Exception e) {
            this.mQName = null;
        }
    }
}

