/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.form;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.Attribute;
import com.adobe.xfa.Dispatcher;
import com.adobe.xfa.Element;
import com.adobe.xfa.EnumAttr;
import com.adobe.xfa.EventManager;
import com.adobe.xfa.Node;
import com.adobe.xfa.Packet;
import com.adobe.xfa.TextNode;
import com.adobe.xfa.form.FormExclGroup;
import com.adobe.xfa.form.FormField;
import com.adobe.xfa.form.FormModel;
import com.adobe.xfa.form.FormSubform;
import com.adobe.xfa.form.SignDispatcher;
import com.adobe.xfa.template.TemplateModel;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.StringUtils;
import java.util.ArrayList;
import java.util.List;

class SubmitDispatcher
extends Dispatcher {
    private final Element mSubmitNode;
    private final boolean mbValidate;

    SubmitDispatcher(Element submitContextNode, String sEventContext, int nEventID, EventManager eventManager, Element submitNode, boolean bValidate) {
        super(submitContextNode, sEventContext, nEventID, eventManager);
        this.mSubmitNode = submitNode;
        this.mbValidate = bValidate;
    }

    @Override
    public void dispatch() {
        EventManager poEventManager;
        Element node = this.getActionContextNode();
        if (node == null) {
            return;
        }
        assert (node instanceof FormField || node instanceof FormSubform || node instanceof FormExclGroup);
        FormModel formModel = (FormModel)node.getModel();
        FormModel.Submit submit = formModel.getSubmit();
        if (submit == null) {
            return;
        }
        String sPreSubmit = EnumAttr.getString(4915217);
        String sPostSubmit = EnumAttr.getString(4915224);
        if (sPreSubmit.length() != 0) {
            formModel.eventOccurred(sPreSubmit, formModel);
        }
        if ((poEventManager = this.getEventManager()) != null && !poEventManager.cancelAction("submit")) {
            String sSubmitURL = formModel.getSubmitURL();
            Packet execEvent = null;
            if (!StringUtils.isEmpty(sSubmitURL)) {
                AppModel appModel = (AppModel)formModel.getXFAParent();
                execEvent = (Packet)appModel.createElement(220, "execEvent");
                appModel.appendChild(execEvent, false);
                submit.setPacketToIgnore(execEvent);
                TemplateModel oTemplateModel = TemplateModel.getTemplateModel(appModel, false);
                int nOriginalVersion = oTemplateModel.getOriginalXFAVersion();
                if (nOriginalVersion >= 30) {
                    execEvent.setAttribute("$form", "context");
                } else {
                    execEvent.setAttribute(node.getSOMExpression(formModel, false), "context");
                }
                execEvent.setAttribute(sPreSubmit, "activity");
            }
            boolean bValid = true;
            if (this.mbValidate) {
                bValid = formModel.performPreEventValidations();
            }
            if (bValid) {
                int eFormat = this.getFormat();
                String sPackets = this.getXDPContent();
                boolean bEmbedPDF = this.getEmbedPDF();
                String sTarget = this.getTarget();
                String sTextEncoding = this.getTextEncoding();
                String sCertificate = this.getCertificate();
                if (sTextEncoding.startsWith("UTF")) {
                    sTextEncoding = sTextEncoding.toLowerCase();
                }
                if (StringUtils.isEmpty(sPackets)) {
                    sPackets = "datasets pdf xfdf";
                }
                if (execEvent != null && !sPackets.contains("execEvent")) {
                    sPackets = sPackets + " execEvent";
                }
                if (bEmbedPDF && !sPackets.contains("pdf")) {
                    sPackets = sPackets + " pdf";
                }
                String[] packets = sPackets.split(" ");
                List<SignDispatcher> signDispatchers = this.getSignDispatchers();
                FormModel.Submit.SubmitParams params = new FormModel.Submit.SubmitParams(packets, sTarget, eFormat, sTextEncoding, bEmbedPDF);
                params.setCertificate(sCertificate);
                params.setSignDispatchers(signDispatchers);
                try {
                    submit.submit(params);
                }
                catch (ExFull oError) {
                    submit.setPacketToIgnore(null);
                    if (execEvent != null && execEvent.getXFAParent() != null) {
                        execEvent.remove();
                    }
                    if (!StringUtils.isEmpty(sPostSubmit)) {
                        formModel.eventOccurred(sPostSubmit, formModel);
                    }
                    throw oError;
                }
            } else {
                ExFull exFull = new ExFull(ResId.FormSubmitCancelled);
                formModel.addErrorList(exFull, 3, this.getActionContextNode());
            }
            submit.setPacketToIgnore(null);
            if (execEvent != null && execEvent.getXFAParent() != null) {
                execEvent.remove();
            }
        }
        if (sPostSubmit.length() != 0) {
            formModel.eventOccurred(sPostSubmit, formModel);
        }
    }

    @Override
    public String getDispatcherType() {
        return "submit";
    }

    @Override
    public String getParameter(int nParam) {
        if (nParam == 0) {
            return this.getTarget();
        }
        return "";
    }

    int getFormat() {
        if (this.mSubmitNode != null) {
            return this.mSubmitNode.getEnum(377);
        }
        return 0;
    }

    String getXDPContent() {
        String sXDPContent = "";
        if (this.mSubmitNode != null) {
            Attribute content = this.mSubmitNode.getAttribute(716);
            sXDPContent = content.toString();
        }
        return sXDPContent;
    }

    boolean getEmbedPDF() {
        int eEmbedPDF;
        boolean bEmbedPDF = false;
        if (this.mSubmitNode != null && (eEmbedPDF = this.mSubmitNode.getEnum(486)) == 0x40040001) {
            bEmbedPDF = true;
        }
        return bEmbedPDF;
    }

    String getTarget() {
        String sTarget = "";
        if (this.mSubmitNode != null) {
            Attribute targetAttr = this.mSubmitNode.getAttribute(670);
            sTarget = targetAttr.toString();
        }
        return sTarget;
    }

    String getTextEncoding() {
        String sTextEncoding = "";
        if (this.mSubmitNode != null) {
            Attribute textEncoding = this.mSubmitNode.getAttribute(672);
            sTextEncoding = textEncoding.toString();
        }
        return sTextEncoding;
    }

    String getCertificate() {
        TextNode contents;
        Element certificate;
        Element encrypt;
        String sCert = null;
        if (this.mSubmitNode != null && (encrypt = this.mSubmitNode.peekElement(114, false, 0)) != null && (certificate = encrypt.peekElement(43, false, 0)) != null && (contents = certificate.getText(false, false, false)) != null) {
            sCert = contents.getValue();
        }
        return sCert;
    }

    List<SignDispatcher> getSignDispatchers() {
        ArrayList<SignDispatcher> signDispatchers = new ArrayList<SignDispatcher>();
        if (this.mSubmitNode != null) {
            for (Node child = this.mSubmitNode.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                if (!child.isSameClass(280)) continue;
                EventManager eventManager = this.getEventManager();
                SignDispatcher sd = new SignDispatcher(this.getActionContextNode(), (Element)child, this.getEventContext(), this.getEventID(), eventManager);
                signDispatchers.add(sd);
            }
        }
        return signDispatchers;
    }
}

