/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.workflow.job;


import org.apache.sling.event.EventUtil;
import org.osgi.service.event.Event;

import java.io.Serializable;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;

/**
 * Helper class to identify and create external process job events, identified by job topic {@link #JOB_TOPIC}
 */
public class ExternalProcessJob implements Serializable {

    private static final long serialVersionUID = 5718625605490930738L;

    /**
     * The job topic for adding an entry to the audit log.
     */
    public static final String JOB_TOPIC = "com/adobe/granite/workflow/external/job";

    public static final String JOB_TOPIC_WC = "com/adobe/granite/workflow/external/job/*";

    /**
     * The event property holding the {@link ExternalProcessJob}.
     */
    public static final String WORKFLOW_JOB = "com.adobe.granite.workflow.job";

    public static final String WORKFLOW_JOB_ID = "com.adobe.granite.workflow.jobid";

    /**
     * The serialized {@link com.adobe.granite.workflow.exec.WorkItem} {@link java.util.Map} of the job.
     */
    protected Map serializedItem;

    /**
     * Creates a new WorkflowJob.
     * @param serializedItem the serialized item
     */
    public ExternalProcessJob(Map serializedItem) {
        if (serializedItem == null) {
            throw new IllegalArgumentException("Resource must not be null.");
        }
        this.serializedItem = serializedItem;
    }

    /**
     * Returns the {@link com.adobe.granite.workflow.exec.WorkItem}s {@link java.util.Map} of the job
     * @return the {@link com.adobe.granite.workflow.exec.WorkItem}s {@link java.util.Map} of the job
     */
    public Map getWorkItemMap() {
        return serializedItem;
    }

    /**
     * Convenience method to create a job event for the workflow job.
     * @param retryCount the number of retries
     * @param jobId the workflow job id
     * @return the created event
     */
    public Event createJobEvent(Integer retryCount, String jobId) {
        final Dictionary<String, Object> props = new Hashtable<String, Object>();
        props.put(WORKFLOW_JOB, this);
//        props.put(EventUtil.PROPERTY_JOB_RETRIES, retryCount);
        if (serializedItem.get("workflowModelId") != null) {
            String workflowModelId = (String) serializedItem.get("workflowModelId");
            //replace colon, see http://bugs.day.com/bugzilla/show_bug.cgi?id=31340
            workflowModelId = workflowModelId.replace(":", "_");
            props.put(EventUtil.PROPERTY_JOB_TOPIC, JOB_TOPIC + workflowModelId);
        } else {
            props.put(EventUtil.PROPERTY_JOB_TOPIC, JOB_TOPIC);
        }

        props.put(WORKFLOW_JOB_ID, jobId);

        return new Event(EventUtil.TOPIC_JOB, props);
    }

}
