/*
 *
 *	File: PDFFontException.java
 *
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 */
package com.adobe.internal.pdftoolkit.core.exceptions;


/**
 * This exception indicates an error in the AFE font set or
 * in one of the individual fonts in that font set has occurred.  A client should
 * consider rebuilding this font set before continuing further
 * operations with the Adobe PDF Java Toolkit.
 */
public class PDFFontException extends PDFException
{
	/**
	 * This is a default serialVersionUID.
	 */
	private static final long serialVersionUID = 1L;

	/**
     * Create a new PDFFontException.
     * @param message the detail message.
     */
    public PDFFontException(String message)
    {
        super(message);
    }

    /**
     * Create a new PDFFontException wrapping an existing exception.
     * @param message the detail message.
     * @param cause the cause.
     */
    public PDFFontException(String message, Throwable cause)
    {
        super(message, cause);
    }

    /**
     * Create a new PDFFontException wrapping an existing exception.
     * @param cause the cause.
     */
    public PDFFontException(Throwable cause)
    {
        super(cause);
    }

}
