/***************************************************************************/
/*                                                                         */
/*                      ADOBE CONFIDENTIAL                                 */
/*                      _ _ _ _ _ _ _ _ _ _                                */
/*                                                                         */
/*  Copyright 2001-2002, Adobe Systems Incorporated                        */
/*  All Rights Reserved.                                                   */
/*                                                                         */
/*  NOTICE: All information contained herein is, and remains the property  */
/*  of Adobe Systems Incorporated and its suppliers, if any.  The          */
/*  intellectual and technical concepts contained herein are proprietary   */
/*  to Adobe Systems Incorporated and its suppliers and may be covered by  */
/*  U.S. and Foreign Patents, patents in process, and are protected by     */
/*  trade secret or copyright law.  Dissemination of this information or   */
/*  reproduction of this material is strictly forbidden unless prior       */
/*  written permission is obtained from Adobe Systems Incorporated.        */
/*                                                                         */
/***************************************************************************/
package com.adobe.versioncue.nativecomm.msg;

import java.nio.ByteBuffer;

/**
 * @author <a href="mailto:tnaroska@adobe.com">Timo Naroska</a>
 * @version $Revision: #1 $
 */
public final class NCData extends NCType
{
	// --------------------------------------------------------------------------- Private Variables

	/** ByteBuffer value */
	private final ByteBuffer value;

	// -------------------------------------------------------------------------- Public Constructor

	/**
	 * Create a <code>NCData</code> instance.
	 * 
	 * @param value ByteBuffer value of the created instance
	 */
	public NCData(byte[] value)
	{
		this(ByteBuffer.wrap(value));
	}

	/**
	 * Create a <code>NCData</code> instance.
	 * 
	 * @param value ByteBuffer value of the created instance
	 * @param offset offset of the subarray to be used
	 * @param length length of the subarray to be used
	 */
	public NCData(byte[] value, int offset, int length)
	{
		this(ByteBuffer.wrap(value, offset, length));
	}

	/**
	 * Constructs a <code>NCData</code> object holding the specified bytes. The
	 * NCData instance creates a copy of the specified ByteBuffer object.
	 * 
	 * @param value bytes represented by the created object
	 * */
	public NCData(ByteBuffer value)
	{
		// == PRE-CONDITION ========================================================================
		assert value != null : "value != null";
		// == PRE-CONDITION ========================================================================

		this.value = value.duplicate();
	}

	// ------------------------------------------------------------------------------ Public Methods

	/**
	 * Returns the number of bytes
	 * 
	 * @return number of bytes
	 */
	public int count()
	{
		return value.remaining();
	}

	/**
	 * Returns the ByteBuffer value of this object
	 * 
	 * @return ByteBuffer value of this object
	 */
	public ByteBuffer bytes()
	{
		return value.duplicate();
	}

	/**
	 * Returns the value of this object as byte[]
	 * 
	 * @return byte[] value of this object
	 */
	public byte[] byteArray()
	{
		if (value.hasArray() && value.arrayOffset() == 0)
		{
			byte[] array = value.array();
			if (value.position() == 0 && value.limit() == array.length)
			{
				return array;
			}
		}

		ByteBuffer temp = value.duplicate();

		byte[] result = new byte[temp.remaining()];
		temp.get(result);
		return result;
	}

	// ---------------------------------------------------------------------------- NCType Overrides

	@Override
	public int getType()
	{
		return TYPE_BYTEBUFFER;
	}

	// ------------------------------------------------------------------ java.lang.Object Overrides

	@Override
	public int hashCode()
	{
		return value.hashCode();
	}

	@Override
	public boolean equals(Object other)
	{
		if (other != null && other instanceof NCData)
		{
			NCData otherData = (NCData) other;
			return value.equals(otherData.value);
		}
		return false;
	}

	@Override
	public String toString()
	{
		return "NCData <" + value + ">";
	}
}
