/*************************************************************************
 *
 *	File: DataMatrixMatrixBuilder.java
 *
 **************************************************************************
 * 
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.xfa.pmp.datamatrixpmp;

import java.util.List;

import com.adobe.xfa.pmp.datamatrixpmp.DataMatrixInfo.Sizes;
import com.adobe.xfa.pmp.datamatrixpmp.matrix.Matrix10;
import com.adobe.xfa.pmp.datamatrixpmp.matrix.Matrix104;
import com.adobe.xfa.pmp.datamatrixpmp.matrix.Matrix12;
import com.adobe.xfa.pmp.datamatrixpmp.matrix.Matrix120;
import com.adobe.xfa.pmp.datamatrixpmp.matrix.Matrix132;
import com.adobe.xfa.pmp.datamatrixpmp.matrix.Matrix14;
import com.adobe.xfa.pmp.datamatrixpmp.matrix.Matrix144;
import com.adobe.xfa.pmp.datamatrixpmp.matrix.Matrix16;
import com.adobe.xfa.pmp.datamatrixpmp.matrix.Matrix18;
import com.adobe.xfa.pmp.datamatrixpmp.matrix.Matrix20;
import com.adobe.xfa.pmp.datamatrixpmp.matrix.Matrix22;
import com.adobe.xfa.pmp.datamatrixpmp.matrix.Matrix24;
import com.adobe.xfa.pmp.datamatrixpmp.matrix.Matrix26;
import com.adobe.xfa.pmp.datamatrixpmp.matrix.Matrix32;
import com.adobe.xfa.pmp.datamatrixpmp.matrix.Matrix36;
import com.adobe.xfa.pmp.datamatrixpmp.matrix.Matrix40;
import com.adobe.xfa.pmp.datamatrixpmp.matrix.Matrix44;
import com.adobe.xfa.pmp.datamatrixpmp.matrix.Matrix48;
import com.adobe.xfa.pmp.datamatrixpmp.matrix.Matrix52;
import com.adobe.xfa.pmp.datamatrixpmp.matrix.Matrix64;
import com.adobe.xfa.pmp.datamatrixpmp.matrix.Matrix72;
import com.adobe.xfa.pmp.datamatrixpmp.matrix.Matrix80;
import com.adobe.xfa.pmp.datamatrixpmp.matrix.Matrix88;
import com.adobe.xfa.pmp.datamatrixpmp.matrix.Matrix96;

/**
 * Ported from DataMatrixMatrixBuilder.cpp
 */
class DataMatrixMatrixBuilder {
	// ////////////////////////////////////////////////////////////////////
	/**
	 * Builds the in memory image of the barcode.
	 * 
	 * @throws DataMatrixEncoderException
	 */
	// ////////////////////////////////////////////////////////////////////
	static DataMatrixMatrix buildMatrix(List<Integer> codeWords, // In: The
																	// barcode
																	// codewords.
			int symbolSize // In: Desired symbol size.
	) throws DataMatrixEncoderException {
		int[] mx = null;
		int[] my = null;
		Sizes sizes = Sizes.getInstance(symbolSize);
		if (sizes == null) {
			// DataMatrix not supported
			throw new DataMatrixEncoderException(
					DataMatrixEncoderErrorCode.MATRIX_NOT_SUPPORTED);
		}
		// const DataLocation* m = m_matrix10;

		switch (sizes) {
		case SIZE_10_10:
			mx = Matrix10.m_matrixX;
			my = Matrix10.m_matrixY;
			break;
		case SIZE_12_12:
			mx = Matrix12.m_matrixX;
			my = Matrix12.m_matrixY;
			break;
		case SIZE_14_14:
			mx = Matrix14.m_matrixX;
			my = Matrix14.m_matrixY;
			break;
		case SIZE_16_16:
			mx = Matrix16.m_matrixX;
			my = Matrix16.m_matrixY;
			break;
		case SIZE_18_18:
			mx = Matrix18.m_matrixX;
			my = Matrix18.m_matrixY;
			break;
		case SIZE_20_20:
			mx = Matrix20.m_matrixX;
			my = Matrix20.m_matrixY;
			break;
		case SIZE_22_22:
			mx = Matrix22.m_matrixX;
			my = Matrix22.m_matrixY;
			break;
		case SIZE_24_24:
			mx = Matrix24.m_matrixX;
			my = Matrix24.m_matrixY;
			break;
		case SIZE_26_26:
			mx = Matrix26.m_matrixX;
			my = Matrix26.m_matrixY;
			break;
		case SIZE_32_32:
			mx = Matrix32.m_matrixX;
			my = Matrix32.m_matrixY;
			break;
		case SIZE_36_36:
			mx = Matrix36.m_matrixX;
			my = Matrix36.m_matrixY;
			break;
		case SIZE_40_40:
			mx = Matrix40.m_matrixX;
			my = Matrix40.m_matrixY;
			break;
		case SIZE_44_44:
			mx = Matrix44.m_matrixX;
			my = Matrix44.m_matrixY;
			break;
		case SIZE_48_48:
			mx = Matrix48.m_matrixX;
			my = Matrix48.m_matrixY;
			break;
		case SIZE_52_52:
			mx = Matrix52.m_matrixX;
			my = Matrix52.m_matrixY;
			break;
		case SIZE_64_64:
			mx = Matrix64.m_matrixX;
			my = Matrix64.m_matrixY;
			break;
		case SIZE_72_72:
			mx = Matrix72.m_matrixX;
			my = Matrix72.m_matrixY;
			break;
		case SIZE_80_80:
			mx = Matrix80.m_matrixX;
			my = Matrix80.m_matrixY;
			break;
		case SIZE_88_88:
			mx = Matrix88.m_matrixX;
			my = Matrix88.m_matrixY;
			break;
		case SIZE_96_96:
			mx = Matrix96.m_matrixX;
			my = Matrix96.m_matrixY;
			break;
		case SIZE_104_104:
			mx = Matrix104.m_matrixX;
			my = Matrix104.m_matrixY;
			break;
		case SIZE_120_120:
			mx = Matrix120.m_matrixX;
			my = Matrix120.m_matrixY;
			break;
		case SIZE_132_132:
			mx = Matrix132.m_matrixX;
			my = Matrix132.m_matrixY;
			break;
		case SIZE_144_144:
			mx = Matrix144.m_matrixX;
			my = Matrix144.m_matrixY;
			break;
		default: // DataMatrix not supported
			throw new DataMatrixEncoderException(
					DataMatrixEncoderErrorCode.MATRIX_NOT_SUPPORTED);
		}

		int matrixRows = DataMatrixInfo.NUM_ROWS[symbolSize];
		int matrixCols = DataMatrixInfo.NUM_COLS[symbolSize];

		DataMatrixMatrix matrix = new DataMatrixMatrix();
		matrix.create(matrixCols, matrixRows);

		int v;
		int row;
		int col;
		for (row = 0; row < matrixRows; row++) {
			for (col = 0; col < matrixCols; col++) {
				int n = row * matrixRows + col;
				int bByte = mx[n];
				int bBit = my[n];

				if (bByte == -1)
					v = 1;
				else if (bByte == -2)
					v = 0;
				else
					v = (codeWords.get(bByte) >> bBit) & 1;
				matrix.set(col, row, v);
			}
		}
		return matrix;
	}
}
