/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.text;


import com.adobe.xfa.ut.Storage;


/**
 * @exclude from published api.
 */
class PosnStack extends Storage<TextPosn> {

	static final long serialVersionUID = 4437578512627526202L;

	PosnStack () {
	}

	PosnStack (PosnStack source) {
		int depth = source.size();
		ensureCapacity (depth);
		for (int i = 0; i < depth; i++) {
			add (new TextPosn ((TextPosn) source.get(i)));
		}
	}

	TextPosn top () {
		return (TextPosn) last();
	}

	void push (TextPosnBase oPosn) {
		add (new TextPosn (oPosn));
	}

	TextPosnBase pop () {
		TextPosnBase oResult = null;
		if (size() > 0) {
			oResult = (TextPosn) last();
			removeLast();
		}
		return oResult;		// caller owns it now
	}
}