/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.dam.handler.ffmpeg;

import org.apache.commons.exec.LogOutputStream;
import org.slf4j.Logger;

/**
 * Provides an output stream injecting lines into the given logger. To be used in conjunction with
 * Apache Common's exec library for logging the output of external commands.
 */
public class LoggerOutputStream extends LogOutputStream {

    private Logger log;
    private FFMpegWrapper wrapper;

    public void setWrapper(FFMpegWrapper wrapper) {
        this.wrapper = wrapper;
    }

    public LoggerOutputStream(final Logger log) {
        super();
        this.log = log;
        if (null == log) {
            throw new IllegalArgumentException("logger may not be null");
        }
    }

    @Override
    protected void processLine(final String line, final int level) {
        log.info("FFMPEG Exec: {}", line);
        if(wrapper != null){
            wrapper.getFFMpegOutput().append(line).append("\n");
        }
    }
}
