/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.day.cq.dam.handler.gibson.fontmanager;

import com.adobe.internal.pdftoolkit.core.fontset.PDFFontSet;

/**
 * The <code>FontManagerService</code> provides access to font related
 * information. It also manages the {@link PDFFontSet} created from all the
 * fonts found in configured directories
 */
public interface FontManagerService {

    /**
     * Location of the System Fonts directory. If more than one system directory
     * is configured then it would return a concatenated string where paths are
     * delimited by semicolon (;)
     * 
     * @return absolute path for the font directory.
     */
    String getSystemFontDirectory();

    /**
     * Location of directory which stores the Adobe provided fonts
     * 
     * @return absolute path for the font directory
     */
    String getAdobeServerFontDirectory();

    /**
     * Location of directory which stores the Customer provided fonts
     * 
     * @return absolute path for the font directory
     */
    String getCustomerFontDirectory();

    /**
     * Returns the PDFFontSet constructed from reading all the fonts found in
     * all the configured font directory
     * 
     * @return generated PDFFontSet from the configured directories
     */
    PDFFontSet getPdfFontSet();
}
