/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.mcm.emailprovider;

/**
 * This exception is thrown by email providers in case of error.
 */
public class EmailServiceException extends Exception {

    /**
     * Default constructor
     */
    public EmailServiceException() {
    }

    /**
     * Constructor that takes error message as argument
     * 
     * @param message The error message
     */
    public EmailServiceException(String message) {
        super(message);
    }

    /**
     * Constructor that takes the Throwable root cause as argument.
     * 
     * @param throwable The root cause Throwable instance.
     */
    public EmailServiceException(Throwable throwable) {
        super(throwable);
    }

    /**
     * Constructor that takes error message and Throwable root cause as argument.
     * 
     * @param message The error message
     * @param throwable The root cause Throwable instance.
     */
    public EmailServiceException(String message, Throwable throwable) {
        super(message, throwable);
    }
}
