/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.wcm.designimporter.parser;

import com.day.cq.dam.indd.PageComponent;

import java.util.List;

/**
 *
 */
public class ParseResult {

    private List<PageComponent> components;

    private ModifiableHTMLContent headHtmlContent;

    private ModifiableHTMLContent bodyHtmlContent;

    private String language;

    public ParseResult(List<PageComponent> components, HTMLContent headHtmlContent, HTMLContent bodyHtmlContent, String language) {
        this.components = components;
        this.headHtmlContent = new ModifiableHTMLContent(headHtmlContent);
        this.bodyHtmlContent = new ModifiableHTMLContent(bodyHtmlContent);
        this.language = language;
    }

    /**
     * Gets the list of {@link PageComponent} objects tranlated from the marked component
     * divs during the import process
     *
     * @return The {@link List} of {@link PageComponent} objects
     */
    public List<PageComponent> getComponents() {
        return components;
    }

    /**
     * Gets the {@link ModifiableHTMLContent} associated with the head of the input HTML document.
     *
     * @return The {@link ModifiableHTMLContent}
     */
    public ModifiableHTMLContent getHeadHtmlContent() {
        return headHtmlContent;
    }

    /**
     * Gets the {@link ModifiableHTMLContent} associated with the body of the input HTML document.
     *
     * @return The {@link ModifiableHTMLContent}
     */
    public ModifiableHTMLContent getBodyHtmlContent() {
        return bodyHtmlContent;
    }

    /**
     * Gets the language specified in the input HTML document.
     *
     * @return The locale represented by the lang attribute in HTML
     */
    public String getLanguage() {
        return language;
    }
}