/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.wcm.designimporter.parser.taghandlers;

import java.util.HashMap;

import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.ccil.cowan.tagsoup.AttributesImpl;
import org.xml.sax.Attributes;

import com.day.cq.dam.indd.PageComponent;
import com.day.cq.wcm.designimporter.DesignImportException;
import com.day.cq.wcm.designimporter.parser.HTMLContentType;
import com.day.cq.wcm.designimporter.util.TagUtils;

/**
 * The default component tag handler is used to translate a non-registered component div
 * into a CQ component. It generates a CQ component with resourceType as the value of the
 * attribute data-cq-component.
 *
 * <p>
 * This tag handler is registered against the markup of type < div data-cq-component="geometrixx/components/mycustomtextcomponent" >. That implies
 * this tag handler will come into action whenever the design importer framework
 * encounters an HTML tag matching the rule this handler is defined against.
 * </p>
 *
 * @see com.day.cq.wcm.designimporter.parser.taghandlers.factory.DefaultComponentTagHandlerFactory
 */
public class DefaultComponentTagHandler extends AbstractTagHandler {

    private String suffix;

    private String prefix;

    private String resourceType;

    @Override
    public void beginHandling(String uri, String localName, String qName, Attributes atts) throws DesignImportException {
        super.beginHandling(uri, localName, qName, atts);

        if ("div".equalsIgnoreCase(localName)) {
            AttributesImpl modAttibutes = new AttributesImpl(atts);
            int index = atts.getIndex("data-cq-component");
            if (index > -1) {
                ValueMap properties = new ValueMapDecorator(new HashMap<String, Object>());
                resourceType = atts.getValue("data-cq-component");
                prefix = resourceType.replace("/", "");
                suffix = designImporterContext.componentSuffixGenerator.getSuffix(prefix);
                PageComponent textComponent = pageBuilder.createComponent(resourceType, properties, getNameHint());
                getPageComponents().add(textComponent);
                modAttibutes.removeAttribute(index);
            }
            startElement(uri, localName, qName, modAttibutes);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws DesignImportException {

    }

    @Override
    public void characters(char[] ch, int start, int length) throws DesignImportException {
        String chars = new String(ch).substring(start, start + length)/* .replace('\n', ' ').replace('\t', ' ').trim() */;
        if (chars.length() > 0) {
            // labelBuffer.append(chars);
        }
    }

    @Override
    public void endHandling(String uri, String localName, String qName) throws DesignImportException {
        super.endHandling(uri, localName, qName);
        if ("div".equalsIgnoreCase(localName)) {
            endElement(uri, localName, qName);
        }

    }

    @Override
    public boolean supportsContent(HTMLContentType htmlContentType) {
        if (htmlContentType == HTMLContentType.MARKUP)
            return true;
        else
            return false;
    }

    private String getNameHint() {
        String name = prefix + suffix;
        return name.replace("_", "");
    }

    @Override
    public Object getContent(HTMLContentType htmlContentType) {

        if (htmlContentType == HTMLContentType.MARKUP && resourceType != null) {
            String cqIncludeJspTag = "<sling:include path=" + "\"" + getNameHint() + "\"" + "/>";

            return componentDivStartTag + cqIncludeJspTag + TagUtils.getMatchingEndTag(componentDivStartTag);
        }

        return null;
    }
}
