/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ************************************************************************/
package com.adobe.cq.dam.index.helper;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.JcrConstants;
import org.apache.jackrabbit.oak.plugins.index.IndexConstants;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class IndexHelper {

    private static Logger log = LoggerFactory.getLogger(IndexHelper.class);
    private static final String DISABLED_INDEX_TYPE = "disabled";

    /**
     * deprioritise index at given resource
     * @param resource index definition resource
     * @return true, if deprioritised successfully
     */
    public static boolean deprioritiseIndex(Resource resource) {
        if (isValidIndexDef(resource)) {
            Node indexDefnNode = resource.adaptTo(Node.class);
            try {
                indexDefnNode.setProperty(IndexConstants.ENTRY_COUNT_PROPERTY_NAME, Long.MAX_VALUE);
                resource.getResourceResolver().commit();
                return true;
            } catch (RepositoryException e) {
                log.error("Error while disabling index.", e);
            } catch (PersistenceException e) {
                log.error("Error while disabling index.", e);
            }
        }
        return false;
    }

    /**
     * disables index at given resource
     * @param resource index definition resource
     * @return true, if disabled successfully
     */
    public static boolean disableIndex(Resource resource) {
        if (isValidIndexDef(resource)) {
            Node indexDefnNode = resource.adaptTo(Node.class);
            try {
                indexDefnNode.setProperty(IndexConstants.TYPE_PROPERTY_NAME, DISABLED_INDEX_TYPE);
                resource.getResourceResolver().commit();
                return true;
            } catch (RepositoryException e) {
                log.error("Error while disabling index.", e);
            } catch (PersistenceException e) {
                log.error("Error while disabling index.", e);
            }
        }
        return false;
    }
    /**
     * Initiates re-indexing
     * @param resource index definition resource
     * @return true, if re-indexing is initiated successfully
     */
    public static boolean reIndex(Resource resource) {
        if (isValidIndexDef(resource)) {
            Node indexDefnNode = resource.adaptTo(Node.class);
            try {
                indexDefnNode.setProperty(IndexConstants.REINDEX_PROPERTY_NAME, true);
                resource.getResourceResolver().commit();
                return true;
            } catch (RepositoryException e) {
                log.error("Error while initiating reindexing.", e);
            } catch (PersistenceException e) {
                log.error("Error while initiating reindexing.", e);
            }
        }
        return false;
    }

    public static long getReIndexCount(Resource resource) {
        if (isValidIndexDef(resource)) {
            ValueMap vm = resource.adaptTo(ValueMap.class);
            return vm.containsKey(IndexConstants.REINDEX_COUNT) ? (Long)vm.get(IndexConstants.REINDEX_COUNT) : 0;
        }
        return -1;
    }

    /**
     * checks if a valid oak index definition node
     */
    private static boolean isValidIndexDef(Resource resource) {
        if (resource == null) {
            return false;
        }
        ValueMap vm = resource.adaptTo(ValueMap.class);
        return  IndexConstants.INDEX_DEFINITIONS_NODE_TYPE.equals(vm.get(JcrConstants.JCR_PRIMARYTYPE));

     }
}
