/*
*
*	File: ElementAttribute.java
*
*
*	ADOBE CONFIDENTIAL
*	___________________
*
*	Copyright 2004-2005 Adobe Systems Incorporated
*	All Rights Reserved.
*
*	NOTICE: All information contained herein is, and remains the property of
*	Adobe Systems Incorporated and its suppliers, if any. The intellectual
*	and technical concepts contained herein are proprietary to Adobe Systems
*	Incorporated and its suppliers and may be covered by U.S. and Foreign
*	Patents, patents in process, and are protected by trade secret or
*	copyright law. Dissemination of this information or reproduction of this
*	material is strictly forbidden unless prior written permission is obtained
*	from Adobe Systems Incorporated.
*
*/

package com.adobe.fontengine.inlineformatting;

/** This class defines attributes which can be placed on elements
 * on {@link com.adobe.fontengine.inlineformatting.AttributedRun AttributedRuns}.
 * 
 * <p>
 * In addition to defining the type for element attribute keys, this class defines a
 * number of well-known element attributes, and in particular all the attributes which
 * are exchanged between an inline formatter and its clients. For each such
 * attribute, we define the possible values.
 * 
 * <p>
 * Other <code>ElementAttribute</code> objects can be created and used by the client
 * of an inline formatter. However, these keys will be ignored by the 
 * inline formatters of this package.
 * 
 * <h4>Concurrency</h4>
 * 
 * Instances of this class are immutable after construction and contain no mutable static
 * data. Therefore, they are threadsafe.
 */

final public class ElementAttribute implements Attribute
{
  
  private final String name;
  
  /** Create a new ElementAttribute.
   * @param name for debugging purposes
   */
  public ElementAttribute (String name) {
    this.name = name;
  }
  
  public String toString () {
    return name;
  }
  
  /** The CSS attributes to use for font selection. 
   * 
   * The value is a 
   * {@link com.adobe.fontengine.inlineformatting.css20.CSS20Attribute}.
   */
  public static final ElementAttribute CSS20Attribute = new ElementAttribute ("CSS20Attribute");
  
  /** The locale for which to format.
   * 
   *  The value is a com.adobe.agl.util.ULocale.
   */
  public static final ElementAttribute locale = new ElementAttribute ("locale");
    
  /** The font used to render an element. 
   * 
   * The value is a non-null
   * {@link com.adobe.fontengine.font.Font com.adobe.fontengine.font.Font} object.
   */
  public static final ElementAttribute font = new ElementAttribute ("font");
  
  /** The font style used to render an element. 
   * 
   * The value must be a {@link FontStyle}
   */
  public static final ElementAttribute fontStyle = new ElementAttribute ("fontStyle");
   
  /** The casing of the text. 
   * 
   * The value must be a {@link TypographicCase}.
   */
  public static final ElementAttribute typographicCase  = new ElementAttribute ("typographicCase");
  
  /** Digit case.
   * 
   * The value must be a {@link DigitCase}.
   * 
   * While {@link #digitCase} can be specified on
   * any digit (i.e. not just Latin digits), it is unlikely to have any 
   * effect on digits which normally occur in a non-cased script
   * (e.g. Arabic digits).
   */
  public static final ElementAttribute digitCase = new ElementAttribute ("digitCase");

  /** Digit width.
   * 
   * The value must be a {@link DigitWidth}.
   */
  public static final ElementAttribute digitWidth = new ElementAttribute ("digitWidth");

  /** The alternate to use for this glyph.
   * The value must be an Integer.
   */
  public static final ElementAttribute alternate = new ElementAttribute ("alternate");
  
  /** Whether the element is a glyph or a character. 
   * 
   *  The value must be 
   * java.lang.Boolean.TRUE or java.lang.Boolean.FALSE. If the value is TRUE,
   * then the font attribute must be set.*/
  public static final ElementAttribute isGlyph = new ElementAttribute ("isGlyph");
  
  /** The point size of an element. 
   * 
   * The value must be a <code>Double</code>.
   */
  public static final ElementAttribute pointSize = new ElementAttribute ("pointSize");
   
  /** The Unicode bidi level of this element. 
   * 
   * The value must be an <code>Integer</code> in the range 0..63. 
   */
  public static final ElementAttribute bidiLevel = new ElementAttribute ("bidiLevel");
  
  /** The joining type for this element. 
   * 
   * This attribute can be set by the inline formatter client on glyph elements,
   * to indicate how they participate in Arabic joining. The value must be 
   * an Integer, the value of which is one of 
   * com.adobe.agl.lang.Ucharacter.JoiningType.*.
   * If this attribute is absent on a glyph element, then it is assumed to
   * have the value UCharacter.JoiningType.NON_JOINING.
   * Inline formatters compute the joining type of character elements.
   */
  public static final ElementAttribute joiningType = new ElementAttribute ("joiningType");
  
}
