/*
*
*	File: InterElementAttribute.java
*
*
*	ADOBE CONFIDENTIAL
*	___________________
*
*	Copyright 2004-2005 Adobe Systems Incorporated
*	All Rights Reserved.
*
*	NOTICE: All information contained herein is, and remains the property of
*	Adobe Systems Incorporated and its suppliers, if any. The intellectual
*	and technical concepts contained herein are proprietary to Adobe Systems
*	Incorporated and its suppliers and may be covered by U.S. and Foreign
*	Patents, patents in process, and are protected by trade secret or
*	copyright law. Dissemination of this information or reproduction of this
*	material is strictly forbidden unless prior written permission is obtained
*	from Adobe Systems Incorporated.
*
*/
package com.adobe.fontengine.inlineformatting;


/**
 * This class defines attributes which can be placed between elements on
 * {@link AttributedRun}s.
 * 
 * <p>
 * In addition to defining the type for inter element attribute keys, this class
 * defines a number of well-known inter element attributes, and in particular
 * all the attributes which are exchanged between an inline formatter and its
 * clients. For each such attribute, we define the possible values.
 * 
 * <p>
 * Other <code>InterElementAttribute</code> objects can be created and used by
 * the client of an inline formatter. However, these keys will be ignored by the
 * inline formatters of this package.
 * 
 * <h4>Concurrency</h4>
 * 
 * Instances of this class are immutable after construction and contain no
 * mutable static data. Therefore, they are threadsafe.
 */
final public class InterElementAttribute implements Attribute {
  
  private final String name;
  
  public InterElementAttribute (String name) {
    this.name = name;
  }
  
  public String toString () {
    return name;
  }
  
  /** The maximimum level of ligature crossing this inter element boundary.
   * The value must be a {@link LigatureLevel}; see that class for
   * the ordering.
   * 
   * <p>If the character stream
   * contains explicit indications about ligatures (e.g. if 
   * U+200C ZERO WIDTH NON-JOINER or U+200D ZERO WIDTH JOINER is
   * present), then those indications override precedence over this attribute.
   * The interpretation of those characters in terms of ligature levels
   * depend on the script, but they are always equivalent to the smallest
   * level ({@link LigatureLevel#NONE}) or the highest level
   * ({@link LigatureLevel#COMMON}).
   */
  public static final InterElementAttribute ligatureLevel 
    = new InterElementAttribute ("ligatureLevel");
}
