/**
 * 
 */
package com.adobe.internal.io;

import java.io.IOException;


/**
 * A simple implementation of the {@link com.adobe.internal.io.ByteWriterFactory ByteWriterFactory}
 * that always constructs {@link com.adobe.internal.io.ByteArrayByteWriter ByteArrayByteWriter} 
 * instances.
 */
public class SimpleByteWriterFactory implements ByteWriterFactory
{
	/**
	 * 
	 */
	public SimpleByteWriterFactory()
	{
		super();
	}

	/**
	 * @see com.adobe.internal.io.ByteWriterFactory#getByteWriter(com.adobe.internal.io.ByteWriterFactory.Longevity, com.adobe.internal.io.ByteWriterFactory.EncryptionStatus, com.adobe.internal.io.ByteWriterFactory.Fixed, long, boolean)
	 */
	public ByteWriter getByteWriter(Longevity longevity,
			EncryptionStatus encryption, Fixed fixed, long size, boolean fast)
	{
		if (size == -1)
		{
			return new ByteArrayByteWriter();
		}
		return new ByteArrayByteWriter((int) size);
	}

	/**
	 * @see com.adobe.internal.io.ByteWriterFactory#getByteWriter(com.adobe.internal.io.ByteWriterFactory.Longevity, com.adobe.internal.io.ByteWriterFactory.EncryptionStatus, com.adobe.internal.io.ByteWriterFactory.Fixed, long[], boolean)
	 */
	public ByteWriter[] getByteWriter(Longevity longevity,
			EncryptionStatus encyrption, Fixed fixed, long[] size, boolean fast)
	{
		ByteWriter[] byteWriters = new ByteWriter[size.length];
		for (int i = 0; i < size.length; i++)
		{
			byteWriters[i] = getByteWriter(longevity, encyrption, fixed, size[i], fast);
		}
		return byteWriters;
	}

	/**
	 * @see com.adobe.internal.io.ByteWriterFactory#closeByteWriter(com.adobe.internal.io.ByteWriter)
	 */
	public void closeByteWriter(ByteWriter byteWriter) 
	throws IOException
	{
		byteWriter.close();
	}

	/**
	 * @see com.adobe.internal.io.ByteWriterFactory#closeFactory()
	 */
	public void closeFactory()
	throws IOException
	{
		// nothing to do - we hold no resources
	}

}
