/* ****************************************************************************
 *
 *	File: Identities.java
 *
 * ****************************************************************************
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2006 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 * ***************************************************************************/

// @author itenenbo

package com.adobe.internal.pdftoolkit.core.securityframework.pki;

import java.util.ArrayList;

import com.adobe.internal.pdftoolkit.core.credentials.Credentials;
import com.adobe.internal.pdftoolkit.core.permissionprovider.PermissionProvider;

public class Identities 
{
	PermissionProvider mPerms = null;
	ArrayList mCredentials;
	
	private Identities(Credentials recipient, PermissionProvider perms)
	{
		mCredentials = new ArrayList();
		mCredentials.add(recipient);
		mPerms = perms;
	}
	
	static public Identities newInstance(Credentials recipient, PermissionProvider permissions)
	{
		return new Identities(recipient, permissions);
	}
	
	static public Identities newInstance(Credentials[] recipients, PermissionProvider permissions)
	{
		Identities identity = newInstance(recipients[0], permissions);
		int idInd;
		for (idInd = 1; idInd < recipients.length; idInd++)
		{
			identity.add(recipients[idInd]);
		}
		return identity;
	}
	
	public void add(Credentials recipient)
	{
		mCredentials.add(recipient);
	}
	
	public void add(Credentials[] recipients)
	{
		int idInd;
		for (idInd = 1; idInd < recipients.length; idInd++)
		{
			add(recipients[idInd]);
		}
	}

	public Credentials[] getCredentials()
	{
		Credentials[] array = new Credentials[mCredentials.size()];
		return (Credentials[]) mCredentials.toArray(array);
	}
	
	public PermissionProvider getPermissions()
	{
		return mPerms;
	}
}
