/*
 * Copyright 1997-2004 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.graphics.chart;

import java.awt.Rectangle;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.NoSuchElementException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.day.cq.graphics.Graph;
import com.day.image.Layer;

/**
 * Implementations extend this
 *
 * @author tripod
 */
// todo: we should have some sort of SPI interface for this
public abstract class Chart {

    /** default logging */
    private final static Logger log = LoggerFactory.getLogger(Chart.class);

    public static final HashMap<String, Class<?>> chartTypes = new HashMap<String, Class<?>>();

    Rectangle position;

    static {
    	registerChartType(LineChart.class);
    	registerChartType(BarChart.class);
    	registerChartType(PieChart.class);
    }

    protected static synchronized void registerChartType(Class<?> chartClass) {
    	try {
    	    if (chartClass.getSuperclass() == Chart.class) {
    	    Method getNameMethod = chartClass.getMethod("getName", new Class[0]);
    	    String typeName = getNameMethod.invoke(null, new Object[0]).toString().toLowerCase();
    	    chartTypes.put(typeName, chartClass);
    	    }
    	} catch (NoSuchMethodException nsme) {
    	    // log - should not happen ;-)
    	} catch (InvocationTargetException ite) {
    	    // log - should not happen ;-)
    	} catch (IllegalAccessException iae) {
    	    // log - should not happen ;-)
    	} catch (Exception e) {
    	    log.warn("registerChartType: Cannot register {0}: {1}",
    		chartClass.getName(), e.toString());
    	}
    }

    /**
     * Returns the identification name of the chart
     * @return the  identification name of the chart
     */
    public static String getName() {
	    throw new IllegalStateException("getName must be overwritten by subclass");
    }


    protected Chart() {
    }

    public static Chart getInstance(String typeName) throws NoSuchElementException {
	    Class<?> chartClass = chartTypes.get(typeName.toLowerCase());

    	// Check for validity
    	if (chartClass == null) {
    	    log.warn("getInstance: Unknown chart type " + typeName);
    	    throw new NoSuchElementException("Unknown chart type " + typeName);
    	}

    	// might have to use parameter constructor
    	try {
    	    return (Chart)chartClass.newInstance();
    	} catch (InstantiationException ie) {
    	    // log !!
    	    throw new NoSuchElementException("Cannot instantiate a chart: " + ie.getMessage());
    	} catch (IllegalAccessException iae) {
    	    // log - should not happen ;-)
    	    throw new NoSuchElementException("Cannot instantiate a chart: " + iae.getMessage());
    	}
    }

    public abstract Layer draw(Graph graph, boolean doDraw);
}
