/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.day.cq.replication;

/**
 * <code>ReplicationListener</code> provides an interface to listen for
 * synchronous replications.
 */
public interface ReplicationListener {

    /**
     * Dummy implementation that does nothig.
     */
    ReplicationListener NOP = new ReplicationListener() {

        /**
         * {@inheritDoc}
         *
         * This implementation does nothing.
         */
        public void onStart(Agent agent, ReplicationAction action) {
        }

        /**
         * {@inheritDoc}
         *
         * This implementation does nothing.
         */
        public void onMessage(ReplicationLog.Level level, String message) {
        }

        /**
         * {@inheritDoc}
         *
         * This implementation does nothing.
         */
        public void onEnd(Agent agent, ReplicationAction action, ReplicationResult result) {
        }

        /**
         * {@inheritDoc}
         *
         * This implementation does nothing.
         */
        public void onError(Agent agent, ReplicationAction action, Exception error) {
        }
    };

    /**
     * Called when the replication (transport) is about to begin, i.e. before
     * the transport handler is called.
     * @param agent the replication agent
     * @param action the action
     */
    void onStart(Agent agent, ReplicationAction action);

    /**
     * Called when a message to the replication log is written.
     * @param level the log level
     * @param message the message
     */
    void onMessage(ReplicationLog.Level level, String message);

    /**
     * Called when a replication finished.
     * @param agent the replication agent
     * @param action the action
     * @param result the replication result.
     */
    void onEnd(Agent agent, ReplicationAction action, ReplicationResult result);

    /**
     * Called when an exception during replication occurrs
     * @param agent the replication agent
     * @param action the action
     * @param error the error
     */
    void onError(Agent agent, ReplicationAction action, Exception error);
}