/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.day.cq.replication;

import java.util.Collection;

/**
 * <code>ReplicationLog</code>...
 */
public interface ReplicationLog {

    /**
     * Returns the log level of this log
     * @return the log level
     */
    Level getLevel();

    /**
     * Set the log level
     * @param level the log level
     */
    void setLevel(Level level);

    /**
     * Returns the lines
     * @return the lines.
     */
    Collection<String> getLines();

    /**
     * Log a message with level debug.
     * @param message the log message
     */
    void debug(String message);

    /**
     * Log a message with level debug.
     * @param fmt the message format
     * @param args the message arguments
     * @see String#format(String, Object...)
     */
    void debug(String fmt, Object... args);

    /**
     * Log a message with level info.
     * @param message the log message
     */
    void info(String message);

    /**
     * Log a message with level info.
     * @param fmt the message format
     * @param args the message arguments
     * @see String#format(String, Object...)
     */
    void info(String fmt, Object... args);

    /**
     * Log a message with level warn.
     * @param message the log message
     */
    void warn(String message);

    /**
     * Log a message with level warn.
     * @param fmt the message format
     * @param args the message arguments
     * @see String#format(String, Object...)
     */
    void warn(String fmt, Object... args);

    /**
     * Log a message with level error.
     * @param message the log message
     */
    void error(String message);

    /**
     * Log a message with level error.
     * @param fmt the message format
     * @param args the message arguments
     * @see String#format(String, Object...)
     */
    void error(String fmt, Object... args);

    /**
     * Log level
     */
    public enum Level {

        DEBUG(0),

        INFO(1),

        WARN(2),

        ERROR(3);

        public final int cardinal;

        Level(int cardinal) {
            this.cardinal = cardinal;
        }
    }
}