/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.statistics;

import com.day.crx.statistics.Report;
import com.day.crx.statistics.Entry;

import javax.jcr.RepositoryException;
import javax.jcr.Session;

import java.util.Iterator;

/**
 * @deprecated Please use Adobe Analytics instead
 * <code>StatisticsService</code>...
 */
@Deprecated
public interface StatisticsService {

    /**
     * Runs a report and returns the result of the report. Please note that this
     * implementation serializes access to the underlying session that runs the
     * report. For improved concurrency, use {@link #runReport(Session , Report)}
     * instead and provide your own session.
     * <p/>
     * This method is thread-safe.
     *
     * @param report the report to run.
     * @return the result of the report.
     * @throws RepositoryException if an error occurs while reading from the
     *                             workspace.
     */
    public Iterator runReport(Report report) throws RepositoryException;

    /**
     * Runs a report and returns the result of the report.
     * <p/>
     * This method is thread-safe.
     *
     * @param session The Session to access the data from the repository to
     *                generate the report
     * @param report  the report to run.
     * @return the result of the report.
     * @throws RepositoryException if an error occurs while reading from the
     *                             workspace.
     */
    public Iterator runReport(Session session, Report report)
            throws RepositoryException;
    /**
     * Adds an entry to the statistics workspace.
     *
     * @param entry the entry to add.
     * @throws RepositoryException if an error occurs while writing to the
     *                             workspace.
     */
    public void addEntry(Entry entry) throws RepositoryException;

    /**
     * @return the path where statistics are written to.
     */
    public String getPath();
}
