/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2017 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.wcm.foundation.model.responsivegrid.export;

import com.adobe.cq.export.json.ComponentExporter;
import com.day.cq.wcm.foundation.model.responsivegrid.Breakpoint;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import org.osgi.annotation.versioning.ProviderType;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.Map;

/**
 * Describes the export behavior of a ResponsiveColumn.
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@ProviderType
public interface ResponsiveColumnExporter extends ComponentExporter {

    /**
     *
     * @return A map of {@link Breakpoint}s associated with the column. The keys of the map are the breakpoint names.
     */
    @Nullable
    @JsonIgnore
    Map<String, Breakpoint> getBreakpoints();

    /**
     *
     * @return The CSS class names associated with the column.
     */
    @Nullable
    @JsonIgnore
    String getColumnClassNames();

    /**
     *
     * @return Returns the actual component model that is wrapped inside of the responsive column.
     * This is useful when performing a JSON export of the responsive grid; in such case, responsive child columns act as wrappers for the actual components that are part of the grid.
     */
    @Nonnull
    @JsonUnwrapped
    ComponentExporter getExportedComponent();

    /** {@inheritDoc} */
    @Nonnull
    @Override
    @JsonIgnore
    String getExportedType();
}