/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.msm.api;


/** Handles exceptions that happen during rollout,
 *  to indicate if the rollout can continue or not.  
 */
public interface RolloutExceptionHandler {
    
    public static class RolloutInfo {
        public String src;
        public String target;
        public String user;
        public String operation = "ROLLOUT";
    }
    
    /** @return true if the exception has been handled
     *  and the rollout can continue.
     */
    boolean handleException(Exception e, RolloutInfo info);
}
