/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 1997 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.day.crx;

import java.io.File;

import javax.jcr.AccessDeniedException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

/**
 * This Interface extends the jcr repository by some crx specific methods
 *
 */
public interface CRXRepository extends Repository {

    /**
     * the crx namespace prefix
     */
    String CRX_NAMESPACE_PREFIX = "crx";

    /**
     * the crx namespace uri
     */
    String CRX_NAMESPACE_URI = "http://www.day.com/crx/1.0";

    /**
     * this flag indicates whether this repository is configured to be the preferred master
     * @deprecated Not applicable to Oak.
     */
    @Deprecated
    String REP_CLUSTER_PREFERRED_MASTER = "crx.cluster.preferredMaster";

    /**
     * this flag indicates whether this repository currently operates in master mode.
     * @deprecated Use Sling's discovery API instead - ie by implementing a TopologyEventListener
     */
    @Deprecated
    String REP_CLUSTER_MASTER = "crx.cluster.master";

    /**
     * the cluster id.
     * @deprecated Use Sling's discovery API instead - ie by implementing a TopologyEventListener
     */
    @Deprecated
    String REP_CLUSTER_ID = "crx.cluster.id";

    /**
     * the system id param
     */
    String REP_SYSTEM_ID = "crx.repository.systemid";

    /**
     * the version to display
     */
    String REP_VERSION_DISPLAY_DESC = "jcr.repository.version.display";

    /**
     * desciptor-key name for node-count statistic
     */
    String STATS_NODE_COUNT_PROPERTY = "jcr.repository.stats.nodes.count";

    /**
     * desciptor-key name for property-count statistic
     */
    String STATS_PROP_COUNT_PROPERTY = "jcr.repository.stats.properties.count";

    /**
     * name of the workspace, containing system data, like users etc
     * @deprecated As of CRX 2.0 the automatic initialization of a crx.system
     * workspace is omitted. User data are no stored in each workspace.
     */
    @Deprecated
    String SYSTEM_WORKSPACE_NAME = "crx.system";

    /**
     * Default name for the license properties file
     */
    String LICENSE_PROPERTIES = "license.properties";

    /**
     * Returns the Module with the given name.
     *
     * @param moduleName The name of the {@link CRXModule} to return.
     *
     * @return The installed {@link CRXModule} or <code>null</code> if no
     *      module whose {@link CRXModule#getName()} returns that name is
     *      registered or if <code>moduleName</code> is <code>null</code> or
     *      empty.
     */
    CRXModule getModule(String moduleName);

    /**
     * Returns all currently installed modules. The array is a copy of the
     * internal data structure of installed modules, so modifying the array
     * returned does not influence the installed modules.
     *
     * @return An array of all currently installed modules. If no modules are
     *      installed, an empty array is returned.
     */
    CRXModule[] getModules();

    /**
     * Installs a preconfigured <code>CRXModule</code> into the repository.
     * <p>
     * After {@link CRXModule#start(CRXSession) starting} the module it is
     * registered.
     * <p>
     * If an error occurs, that is if any exception is thrown, the module is
     * not registered and will not be returned by the {@link #getModule(String)}
     * and {@link #getModules()} method.
     *
     * @param session The <code>Session</code> authorizing the installation of
     *      a new module into the repository. If the <code>session</code> does
     *      not have enough rights to install a module, an
     *      <code>AccessDeniedException</code> is thrown.
     * @param module The {@link CRXModule} to install. This must not be
     *      <code>null</code>.
     *
     * @throws NullPointerException Is thrown if <code>session</code> or
     *      <code>module</code> is <code>null</code>.
     * @throws IllegalArgumentException Is thrown if a module with the same
     *      name, that is if another module whose <code>getName()</code>
     *      is equal to the <code>getName()</code> of <code>module</code> or if
     *      {@link CRXModule#getName() module.getName()} returns an empty or
     *      <code>null</code> name.
     * @throws AccessDeniedException Is thrown if the <code>session</code> has
     *      not enough rights to install a module into the repository.
     * @throws RepositoryException Is thrown if the
     *      {@link CRXModule#start(CRXSession)} module fails or if any other
     *      problem occurs during installation.
     */
    void installModule(Session session, CRXModule module)
            throws AccessDeniedException, RepositoryException;

    /**
     * Uninstalls the named <code>CRXModule</code> from the repository.
     * <p>
     * After unregistering the module, the {@link CRXModule#stop()} method is
     * called.
     * <p>
     * If no module with the given name is installed in the system or if
     * <code>moduleName</code> is empty or <code>null</code>, this method
     * has on effect.
     *
     * @param session The <code>Session</code> authorizing the uninstallation of
     *      a module from the repository. If the <code>session</code> does
     *      not have enough rights to uninstall a module, an
     *      <code>AccessDeniedException</code> is thrown.
     * @param moduleName The name as returned by {@link CRXModule#getName()} of
     *      the module to uninstall.
     *
     * @throws AccessDeniedException Is thrown if the <code>session</code> has
     *      not enough rights to install a module into the repository.
     */
    void uninstallModule(Session session, String moduleName)
            throws AccessDeniedException;

    /**
     * Returns the product license of this repository
     *
     * @return the product license of this repository
     * @deprecated Use the Granite License API
     */
    @Deprecated
    License getLicense();

    /**
     * Returns the repository home
     * @return the repository home
     */
    File getHomeDir();

}
