/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.image.font;

/**
 * The <code>FontListEntry</code> class is used to describe one single entry
 * in the list of fonts found on the platform.
 *
 * @author fmeschbe
 * @since coati
 * @audience wad
 */
public class FontListEntry {

    /** The name of the Font Provider for this font */
    private final String fontProvider;

    /** The name of the font list entry */
    private final String facename;

    /** The supported size of the font entry, zero for scalable fonts */
    private final int size;

    /**
     * The style supported by the font entry, <code>0xff</code> for
     * fonts supporting derivation of different styles or which are available
     * in different styles.
     */
    private final int style;

    /**
     * Creates a new font list entry descriptor.
     *
     * @param facename The name of the font represented by this font
     *      list entry.
     * @param size The point size for this font list entry. If this value
     *      is zero, the list entry represents a scalable font, such as a
     *      TrueType font. Else the font represented by this entry only
     *      supports the size given.
     * @param style The style flags of the font. If the font has the
     *      capability to derive several styles, the special value
     *      <code>0xff</code> can be used to specify this behaviour. Else
     *      the font only supports the style given.
     */
    public FontListEntry(String fontProvider, String facename, int size, int style) {
        this.fontProvider = fontProvider;
        this.facename = facename;
        this.size = size;
        this.style = style;
    }

    /**
     * Returns the name of the provider of this font
     */
    public String getFontProvider() {
        return fontProvider;
    }

    /**
     * Returns the font face name of this list entry
     *
     * @return the font face name of this list entry
     */
    public String getFacename() {
        return facename;
    }

    /**
     * Returns the size of this font list entry, or zero if this entry
     * represents a scalable font, such as a TrueType font.
     *
     * @return the size of this font list entry, or zero for a scalable
     *      font.
     */
    public int getSize() {
        return size;
    }

    /**
     * Returns the style flags supported by this font list entry.
     *
     * @return the style flags supported by this font list entry.
     */
    public int getStyle() {
        return style;
    }
}