/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2018 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.export.json.hierarchy;

import java.util.Map;

import javax.annotation.Nullable;

import org.osgi.annotation.versioning.ConsumerType;

import com.adobe.cq.export.json.ComponentExporter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Defines the JSON export of a hierarchical node
 *
 * <p>
 * This interface is aimed at being implemented by Sling Model classes that should provide a JSON export for a hierarchical node and its children.
 * </p>
 * <p>
 * <strong>NOTE</strong>: Getter methods' names are all prefixed to avoid name conflicts with methods from the implementation class.
 * </p>
 */
@ConsumerType
@JsonInclude(JsonInclude.Include.NON_NULL)
public interface HierarchyNodeExporter extends ComponentExporter {

    /**
     * Hierarchical type of the exported node
     *
     * @return
     */
    @Nullable
    @JsonProperty(HierarchyConstants.PN_HIERARCHY_TYPE)
    String getExportedHierarchyType();

    /**
     * Returns the path of the current node
     *
     * @return the exported path
     */
    @JsonProperty(HierarchyConstants.PN_PATH)
    String getExportedPath();

    /**
     * <p>
     * Returns the map of all exported children {@link HierarchyNodeExporter} of the current node
     * </p>
     *
     * <p>Note: the field is added to the exported model when the map contains entries</p>
     *
     * @return the map of all exported children where the key is a unique identifier such as the resource path
     */
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonProperty(HierarchyConstants.PN_CHILDREN)
    Map<String, ? extends HierarchyNodeExporter> getExportedChildren();

}
