/*************************************************************************
* ADOBE CONFIDENTIAL
* ___________________
*
* Copyright 2014 Adobe
* All Rights Reserved.
*
* NOTICE: All information contained herein is, and remains
* the property of Adobe and its suppliers, if any. The intellectual
* and technical concepts contained herein are proprietary to Adobe
* and its suppliers and are protected by all applicable intellectual
* property laws, including trade secret and copyright laws.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe.
**************************************************************************/
package com.adobe.granite.ui.components.rendercondition;

import java.io.IOException;

import javax.servlet.ServletException;

/**
 * The condition if the component should be rendered or not.
 */
public interface RenderCondition {
    /**
     * Returns {@code true} if the component should be rendered; {@code false}
     * otherwise.
     *
     * @return {@code true} if the component should be rendered, {@code false}
     *         otherwise
     * @throws ServletException
     *             in case a servlet error occurs
     * @throws IOException
     *             in case an IO error occurs
     */
    boolean check() throws ServletException, IOException;
}
