/*
 * Adobe Confidential
 * ------------------
 * Copyright 2006 Adobe Systems Incorporated.  All Rights Reserved.
 *
 * Notice: all information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any.  The intellectual and 
 * technical concepts contained herein are proprietary to Adobe Systems Inc.
 * and its suppliers and may be covered by U.S. and foreign patents, patents in 
 * process, and are protected by trade secret or copyright law.  Dissemination 
 * of this information or reproduction of this material is strictly forbidden 
 * unless prior written permission is obtained from Adobe Systems Inc.
 */

package com.adobe.xfa.template;


import com.adobe.xfa.Delta;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.ProtoableNode; 
import com.adobe.xfa.XFA; 
import com.adobe.xfa.XFAList;
import com.adobe.xfa.content.TextValue; 


/**
 * A class for Items objects.
 * An element that describes the constraints on item groups.
 *
 * @exclude from published api.
 */
public final class Items extends ProtoableNode { 

    public Items(Element parent, Node prevSibling) {
        super(parent, prevSibling, null, XFA.ITEMS, XFA.ITEMS,
												null, XFA.ITEMSTAG, XFA.ITEMS);
    }

	/**
	 * Adds a new item.
	 */
	public void	addItem(String sItemValue, boolean bDefault /* = false */) {
		// create the the item
		// Note: Watson 1088597: SAP wants to allow empty "bound"
		// (aka "export") values, so empty values are valid
		//
		TextValue bound = new TextValue(this, null);
		
	    // Note: Watson 1088597: SAP wants to allow empty "bound" (aka "export") values
		// so empty values are valid
		bound.setValue(sItemValue);
		
		// if this is not a transient operation, since we update the node,
		// clear the transient setting for our children.
		if (! bDefault)
			makeNonDefault(true);
	}

	/**
	 * Removes all the items.
	 */
	public void	clearItems(boolean bDefault /* = false */) {
		//
		// Remove all existing children.
		//
		Node child = getFirstXFAChild();
		while (child != null) {
			Node next = child.getNextXFASibling();
			removeChild(child);
			child = next;
		}
		//
		// if this is not a transient operation, since we update the node,
		// clear the transient setting for our children.
		//
		if (! bDefault)
			makeNonDefault(true);
	}

	/**
	 * Removes one item.
	 */
	public void	removeItem(int nIndex, boolean bDefault /* = false */) {
		Node child = getXFAChild(nIndex);
		if (child != null) {
			child.remove();
		//	
		// if this is not a transient operation, since we update the node,
		// clear the transient setting for our children.
		//	
		if (! bDefault)
			makeNonDefault(true);
		}
	}


	// -----------------------------------------
	// Overridden methods of Node
	// -----------------------------------------

	public void getDeltas(Element delta, XFAList list) {
		
		if (isSameClass(delta) && list != null) {
			
			Element parent = getXFAParent();
			Element deltaParent = delta.getXFAParent();
			Delta newDelta = new Delta(parent, deltaParent, this, delta, "");
			list.append(newDelta);
		}
	}

	/**
	 * @see Element#makeNonDefault(boolean)
	 */
	public void makeNonDefault(boolean bRecursive /* = false */) {
		if (isDefault(false)) {
			// fully resolve will remove the default flags
			fullyResolve(true);
		}
	}
}