package com.day.cq.dam.api.s7dam.utils;

import com.day.cq.dam.api.Asset;
import org.apache.sling.api.resource.Resource;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface PreviewUtils {


    /**
     * Check based on asset type if asset is supported for image preview or not
     * @param asset <code>Asset</code> object for which preview is being checked
     * @return boolean
     */
    public boolean isImagePreviewSupported(Asset asset);

    /**
     * Checks whether a resource has dam:scene7Type : Image, AnimatedGif, PsdTemplate, Illustrator, PostScript, Pdf.
     * @param resource
     * @return
     */
    public boolean isDynamicRenditionSupported(Resource resource);
}
